var Transacciones_pago_credito_app=function(){
	this.baseUrl=null;
	this.windowsId=null;
	this.caja=null;
	/*Inicializar entorno*/
	this.initializeEnviroment=function(url,winId,caja){
		this.baseUrl=url;
		this.windowsId=winId;
		this.caja=caja;
		this.initializeGUIComponets();
		this.initializeListeners();
	},
	/*Inicializar componentes de la interfaz*/
	this.initializeGUIComponets=function(){
		/*Chose*/
		$("#"+this.windowsId+" #pago-credito-cliente").chosen({
			no_results_text: "No se encontro ningun resultado",
			allow_single_deselect: true
		});
		$("#"+this.windowsId+" #pago-credito-cliente").trigger("chosen:activate");
		/*Mascaras*/
		$("#"+this.windowsId+" #pago-credito-cliente-dui, #"+this.windowsId+" #pago-credito-info-docs-dui").inputmask({mask:"[99999999-9]"});
		$("#"+this.windowsId+" #pago-credito-cliente-nit, #"+this.windowsId+" #pago-credito-info-docs-nit").inputmask({mask:"[9999-999999-999-9]"});
		$("#"+this.windowsId+" #pago-credito-cliente-nrc, #"+this.windowsId+" #pago-credito-info-docs-nrc").inputmask({mask:"[999999-9]"});
		/*Calendario*/
		$("#"+this.windowsId+" #pago-credito-info-docs-fecha").datepicker({
			language:'es',
			format:'yyyy-mm-dd',
			autoclose:true
		}).on('changeDate',function(ev){
			$("#pago-credito-info-docs-direccion").focus();
		});
		
	},
	/*EVENTOS*/
	this.initializeListeners=function(){
		var _this=this;
		/*SELECT chosen: elegir un cliente (CHANGE)*/
		$("#"+_this.windowsId+" #pago-credito-cliente").on('change',function(e){
			var id=$(this).val();
			$("#"+_this.windowsId+" #pago-credito-doc-pendientes").html("");
			$("#"+_this.windowsId+" #pago-credito-doc-pagar").html("");
			$.get(_this.baseUrl+"clientes/getventascreditoxcliente",{cliente:id},function(docs){
				$("#"+_this.windowsId+" #pago-credito-doc-pendientes").html(docs);
			},'html');
			$optionSelected=$(this).find("option:selected");
			$("#"+_this.windowsId+" #pago-credito-info-docs input.form-control").each(function(index,el){
				$(el).val("");
			});
			/*Nombre cliente*/
			$("#"+_this.windowsId+" #pago-credito-info-docs-cliente").attr("data-default",$optionSelected.attr("data-nombre"));
			$("#"+_this.windowsId+" #pago-credito-info-docs-cliente").val($optionSelected.attr("data-nombre"));
			/*Direccion cliente*/
			$("#"+_this.windowsId+" #pago-credito-info-docs-direccion").attr("data-default",$optionSelected.attr("data-direccion"));
			$("#"+_this.windowsId+" #pago-credito-info-docs-direccion").val($optionSelected.attr("data-direccion"));
			/*DUI cliente*/
			$("#"+_this.windowsId+" #pago-credito-cliente-dui").val($optionSelected.attr("data-dui"));
			$("#"+_this.windowsId+" #pago-credito-info-docs-dui").attr("data-default",$optionSelected.attr("data-dui"));
			$("#"+_this.windowsId+" #pago-credito-info-docs-dui").val($optionSelected.attr("data-dui"));
			/*NIT cliente*/
			$("#"+_this.windowsId+" #pago-credito-cliente-nit").val($(this).find("option:selected").attr("data-nit"));
			$("#"+_this.windowsId+" #pago-credito-info-docs-nit").attr("data-default",$optionSelected.attr("data-nit"));
			$("#"+_this.windowsId+" #pago-credito-info-docs-nit").val($optionSelected.attr("data-nit"));
			/*NRC cliente*/
			$("#"+_this.windowsId+" #pago-credito-cliente-nrc").val($(this).find("option:selected").attr("data-nrc"));
			$("#"+_this.windowsId+" #pago-credito-info-docs-nrc").attr("data-default",$optionSelected.attr("data-nrc"));
			$("#"+_this.windowsId+" #pago-credito-info-docs-nrc").val($optionSelected.attr("data-nrc"));
			/*Direccion cliente*/
			$("#"+_this.windowsId+" #pago-credito-info-docs-giro").attr("data-default",$optionSelected.attr("data-giro"));
			$("#"+_this.windowsId+" #pago-credito-info-docs-giro").val($optionSelected.attr("data-giro"));
			_this.calcTotal();
		});
		/*BOTON trasladar un documento a documentos a pagar (CLICK)*/
		$("#"+_this.windowsId+" #pago-credito-doc-pendientes").on("click",".panel .panel-heading button.agregar-documento-all-btn",function(){
			_this.trasladarDocumentoPagar($(this).closest("div.panel"));
		});
		/*BOTON trasladar un item a documentos a pagar (CLICK) PENDIENTE*/
		$("#"+_this.windowsId+" #pago-credito-doc-pendientes").on("click",".panel table tbody tr td button.agregar-documento-item-btn",function(){});
		/*BOTON trasladar un documento a documentos pendientes CLICK()*/
		$("#"+_this.windowsId+" #pago-credito-doc-pagar").on("click",".panel .panel-heading button.quitar-documentopagar-all-btn",function(){
			_this.trasladarDocumentoPendientes($(this).closest("div.panel"));
		});
		/*BOTON guardar pago de credito (CLICK)*/
		$("#"+_this.windowsId+" #guardar-pago-credito-btn").click(function(){
			if(!$(this).is(':disabled')){
				_this.validarPagoCredito($(this));
			}
		});
		/*LINK Modificar informacion de factura (CLICK)*/
		$("#"+this.windowsId+" #pago-credito-doc-mod-info-link").click(function(){
			_this.modificarFacturaInfo();
		});
		/*BOTON restablecer valor de un campo de la informacion de la factura (CLICK)*/
		$("#"+this.windowsId+" .info-docs-field-reset-btn").click(function(e){
			e.preventDefault();
			var $txt=$(this).closest(".input-group").find("input.form-control");
			if($txt.attr("id")=="pago-credito-info-docs-fecha")
				$("#"+_this.windowsId+" #pago-credito-info-docs-fecha").datepicker('update',$txt.attr("data-default"));
			else
				$txt.val($txt.attr("data-default"));
		});
		/*BOTON salir de ventana de modificacion de informacion de facturacion (CLICK)*/
		$("#"+this.windowsId+" #pago-credito-info-docs-cancelar-btn").click(function(){
			$("#"+_this.windowsId+" #pago-credito-info-docs input.form-control").each(function(index,el){
				var $txt=$(this).closest(".input-group").find("input.form-control");
				if($txt.attr("id")=="pago-credito-info-docs-fecha")
					$("#"+_this.windowsId+" #pago-credito-info-docs-fecha").datepicker('update',$(el).attr("data-prev"));
				else
					$(el).val($(el).attr("data-prev"));
			});
			$("#"+_this.windowsId+" #pago-credito-info-docs").modal("hide");
		});
		/*BOTON guardar de modificacion de informacion de facturacion (CLICK)*/
		$("#"+this.windowsId+" #pago-credito-info-docs-guardar-btn").click(function(){
			_this.colocarInformacionFactura();
		});
		/*BOTON guardar informacion de pago credito (CLICK)*/
		$("#"+_this.windowsId+" #pago-credito-info-guardar").click(function(){
			if(!$(this).is(':disabled')){
				_this.validarPagoCredito($(this));
			}
		});
		/*BOTON Cancelar modal informacion de pago credito (CLICK)*/
		$("#"+_this.windowsId+" #pago-credito-info-cancel").click(function(){
			_this.cancelarPagoCredito();
		});
		/*SELECT Cambiar forma de pago (CHANGE)*/
		$("#"+_this.windowsId+" #pago-credito-forma-pago-select").change(function(){
			if($(this).val()==1){
				$("#pago-credito-efectivo-frame").show();
				$("#pago-credito-forma-pago-efectivo").focus();
			}else{
				$("#pago-credito-efectivo-frame").hide();
				$("pago-credito-fpago-guardar-btn").focus();
			}
		});
		/*TEXTBOX ingresar el efectivo y calcular Cambio*/
		$("#"+_this.windowsId+" #pago-credito-forma-pago-efectivo").keyup(function(){
			$("#pago-credito-forma-pago-cambio").val((parseFloat($(this).val()-parseFloat($('#documentos-pagar-totales .total-total-wrapper .data-total').attr('data-value')))).toFixed(2));
		});
		/*BOTON guardar informacion de forma de pago*/
		$("#"+_this.windowsId+" #pago-credito-fpago-guardar-btn").click(function(){
			if(!$(this).is(':disabled')){
				_this.validarPagoCredito($(this));
			}
		});
		/*BOTON cancelar informacion de forma de pago*/
		$("#"+_this.windowsId+" #pago-credito-fpago-cancel-btn").click(function(){
			if(!$(this).is(':disabled')){
				_this.cancelarPagoCredito();
			}
		});
		/*BOTON guardar informacion de cliente*/
		$("#"+_this.windowsId+" #pago-credito-cliente-docs-guardar-btn").click(function(){
			if(!$(this).is(':disabled')){
				_this.validarPagoCredito($(this));
			}
		});
		/*BOTON cancelar informacion de cliente*/
		$("#"+_this.windowsId+" #pago-credito-cliente-docs-cancel-btn").click(function(){
			if(!$(this).is(':disabled')){
				_this.cancelarPagoCredito();
			}
		});
		/*BOTON procesar pago*/
		$("#"+_this.windowsId+" #pago-credito-confirmar-guardar-btn").click(function(){
			if(!$(this).is(':disabled')){
				_this.processPago($(this));
			}
		});
		/*BOTON cancelar procesar pago*/
		$("#"+_this.windowsId+" #pago-credito-cancelar-guardar-btn").click(function(){
			if(!$(this).is(':disabled')){
				_this.cancelarPagoCredito();
			}
		});
		/*BOTON salir procesar pago*/
		$("#pago-credito-confirmar-salir-btn").click(function(){
			$('#pago-credito-confirmar').modal("hide");
			$('#pago-credito-confirmar').on('hidden.bs.modal', function(){
				setTimeout(function(){Custombox.close();}, 100);
			});
		});
		
		/*MODAL informacion del pago*/
		$("#"+_this.windowsId+" #pago-credito-info-wrapper").on("shown.bs.modal", function(){
			_this.setAutoNumDoc($("#pago-credito-doc-pago").val(),true,$("#pago-credito-doc-serie-pago"),$("#pago-credito-numdoc-pago"));
			var docspagar=$("#pago-credito-doc-pagar").find(".documento-pagar-panel");
			$.each(docspagar,function(i,doc){
				if($(doc).attr("data-doc")==0 || $(doc).attr("data-doc")>3){
					$("#"+_this.windowsId+" #pago-credito-doc-fac-pago").removeAttr("disabled");
					$("#"+_this.windowsId+" #pago-credito-doc-fac-serie-pago").removeAttr("disabled");
					$("#"+_this.windowsId+" #pago-credito-numdoc-fac-pago").removeAttr("disabled");
					$("#"+_this.windowsId+" #pago-credito-fac-info-wrapper").show();
					$("#"+_this.windowsId+" #pago-credito-fac-transito").prop("checked","true");
					_this.setAutoNumDoc($("#pago-credito-doc-fac-pago").val(),true,$("#pago-credito-doc-fac-serie-pago"),$("#pago-credito-numdoc-fac-pago"));
					return false;
				}else{
					$("#"+_this.windowsId+" #pago-credito-fac-info-wrapper").hide();
					$("#"+_this.windowsId+" #pago-credito-fac-transito").removeAttr("checked");
				}
			});
			
			$("#pago-credito-numdoc-pago").focus();
		});
		/*SELECT cambiar documento de pago*/
		$("#"+_this.windowsId+" #pago-credito-doc-pago").change(function(){
			_this.setAutoNumDoc($("#pago-credito-doc-pago").val(),true,$("#pago-credito-doc-serie-pago"),$("#pago-credito-numdoc-pago"));
			$("#pago-credito-numdoc-pago").focus();
		});
		/*SELECT cambiar documento de facturacion*/
		$("#"+_this.windowsId+" #pago-credito-doc-fac-pago").change(function(){
			_this.setAutoNumDoc($("#pago-credito-doc-fac-pago").val(),true,$("#pago-credito-doc-fac-serie-pago"),$("#pago-credito-numdoc-fac-pago"));
			$("#pago-credito-numdoc-fac-pago").focus();
		});
		/*SELECT cambiar serie de documento de pago*/
		$("#"+_this.windowsId+" #pago-credito-doc-serie-pago").change(function(){
			$("#pago-credito-numdoc-pago").val($(this).find("option:selected").attr("data-act"));
			$("#pago-credito-numdoc-pago").focus();
		});
		/*SELECT cambiar serie de documento de facturacion*/
		$("#"+_this.windowsId+" #pago-credito-doc-fac-serie-pago").change(function(){
			$("#pago-credito-numdoc-fac-pago").val($(this).find("option:selected").attr("data-act"));
			$("#pago-credito-numdoc-fac-pago").focus();
		});
		/*CHECKBOX seleccionar facturacion de documentos en transito*/
		$("#"+_this.windowsId+" #pago-credito-fac-transito").click(function(){
			if(!$(this).is(":checked")){
				$("#pago-credito-doc-fac-pago").prop("disabled","disabled");
				$("#pago-credito-doc-fac-serie-pago").prop("disabled","disabled");
				$("#pago-credito-numdoc-fac-pago").prop("disabled","disabled");
				$("#"+_this.windowsId+" #pago-credito-info-guardar").focus();
			}else{
				$("#pago-credito-doc-fac-pago").removeAttr("disabled","disabled");
				$("#pago-credito-doc-fac-serie-pago").removeAttr("disabled","disabled");
				$("#pago-credito-numdoc-fac-pago").removeAttr("disabled","disabled");
				$("#pago-credito-numdoc-fac-pago").focus();
			}
		});
		/*------ HOTKEYS ------*/
		/*Campos de editar informacion de documento*/
		$("#"+_this.windowsId+" #pago-credito-info-docs input.form-control").bind('keydown', 'return', function(e){
			switch($(this).attr("id")){
				case "pago-credito-info-docs-cliente":
					$("#"+_this.windowsId+" #pago-credito-info-docs-fecha").focus();
				break;
				case "pago-credito-info-docs-direccion":
					$("#"+_this.windowsId+" #pago-credito-info-docs-dui").focus();
				break;
				case "pago-credito-info-docs-dui":
					$("#"+_this.windowsId+" #pago-credito-info-docs-nit").focus();
				break;
				case "pago-credito-info-docs-nit":
					$("#"+_this.windowsId+" #pago-credito-info-docs-nrc").focus();
				break;
				case "pago-credito-info-docs-nrc":
					$("#"+_this.windowsId+" #pago-credito-info-docs-giro").focus();
				break;
				case "pago-credito-info-docs-giro":
					$("#"+_this.windowsId+" #pago-credito-info-docs-guardar-btn").focus();
				break;
			}
		});
		/*Num documento de pago*/
		$("#"+_this.windowsId+" #pago-credito-numdoc-pago").bind('keydown', 'return', function(e){
			e.preventDefault();
			if(!$("#"+_this.windowsId+" #pago-credito-numdoc-fac-pago").is(":disabled")){
				$("#"+_this.windowsId+" #pago-credito-numdoc-fac-pago").focus();
			}else{
				$("#"+_this.windowsId+" #pago-credito-info-guardar").click();
			}
		});
		/*Num documento de facturacion*/
		$("#"+_this.windowsId+" #pago-credito-numdoc-fac-pago").bind('keydown', 'return', function(e){
			e.preventDefault();
			$("#"+_this.windowsId+" #pago-credito-info-guardar").click();
		});
		/*dui*/
		$("#"+_this.windowsId+" #pago-credito-cliente-dui").bind('keydown', 'return', function(e){
			e.preventDefault();
			$("#"+_this.windowsId+" #pago-credito-cliente-nit").focus();
		});
		/*nit*/
		$("#"+_this.windowsId+" #pago-credito-cliente-nit").bind('keydown', 'return', function(e){
			e.preventDefault();
			$("#"+_this.windowsId+" #pago-credito-cliente-nrc").focus();
		});
		/*nrc*/
		$("#"+_this.windowsId+" #pago-credito-cliente-nrc").bind('keydown', 'return', function(e){
			e.preventDefault();
			$("#"+_this.windowsId+" #pago-credito-cliente-docs-guardar-btn").trigger("click");
		});
		/**/
		$("#"+_this.windowsId+" #pago-credito-forma-pago-efectivo").bind('keydown', 'return', function(e){
			e.preventDefault();
			$("#"+_this.windowsId+" #pago-credito-fpago-guardar-btn").click();
		});
	},
	/*Funciones*/
	/*Trasladar un documento al area de documentos a pagar*/
	this.trasladarDocumentoPagar=function(panel){
		panel.hide();
		var id=panel.attr("id").split("-")[1];
		var condicion=panel.attr("data-condicion");
		var idcred=panel.attr("data-credito");
		var doc=panel.attr("data-doc");
		var numdoc=panel.attr("data-numdoc");
		var docVendedor=panel.attr("data-vendedor");
		var docTotal=panel.attr("data-total");
		
		$("#pago-credito-doc-pagar").append("<div class='documentopagar-traslado-estado-info alert text-center'>Cargando documento...</div>");
		$("#pago-credito-doc-pagar").append("<div class='panel panel-default documento-pagar-panel' id='docpagar-"+id+"' data-condicion='"+condicion+"' data-credito='"+idcred+"' data-doc='"+doc+"' data-numdoc='"+numdoc+"' data-vendedor='"+docVendedor+"' data-total='"+docTotal+"' style='display:none'></div>"); 
		
		var docpagar=$("#pago-credito-doc-pagar").find("#docpagar-"+id);
		docpagar.append(panel.html());
		docpagar.find(".panel-heading > a").attr("href","#documentopagar-"+id);
		docpagar.find(".panel-collapse").attr("id","documentopagar-"+id);
		/**/
		var docButton=docpagar.find(".panel-heading").find(".agregar-documento-all-btn");
		docButton.find("i").attr("class","fa fa-times fa-2x");
		docButton.attr("class","btn btn-danger quitar-documentopagar-all-btn");
		/**/
		var tableItem=docpagar.find(".panel-collapse").find("table.documento-items");
		var tableItems=tableItem.find("tbody > tr");
		$.each(tableItems,function(i,item){
			var itembtn=$(item).find(".item-btn-field > button");
			itembtn.find("i").attr("class","fa fa-times");
			itembtn.attr("class","btn btn-xs btn-danger quitar-documento-item-btn");
		});
		tableItem.attr("class","table documentopagar-items");
		this.calcTotal();
		docpagar.show();
		$(".documentopagar-traslado-estado-info").remove();
	}
	/*Trasladar un documento al area de documentos pendientes*/
	this.trasladarDocumentoPendientes=function(panel){
		var id=panel.attr("id").split("-")[1];
		panel.remove();
		$("#pago-credito-doc-pendientes").find("#doc-"+id).show();
		this.calcTotal();
	},
	/*Abrir modal de informacion de factura*/
	this.modificarFacturaInfo=function(){
		var _this=this;
		$("#"+this.windowsId+" #pago-credito-info-docs").on('shown.bs.modal',function(){
			$("#"+_this.windowsId+" #pago-credito-info-docs input.form-control").each(function(index,el){
				if($(el).attr("id")=="pago-credito-info-docs-fecha" && !$(el).val().length)
					$("#"+_this.windowsId+" #pago-credito-info-docs-fecha").datepicker('update',$(el).attr("data-default"));
					
				$(el).attr("data-prev",$(el).val());
			});
			$("#"+this.windowsId+" #pago-credito-info-docs-cliente").focus();
		});
		$("#pago-credito-info-docs").modal({backdrop: 'static', keyboard: false});
		$("#pago-credito-info-docs").modal("show");
	},
	/*Validar y colocar informacion de factura*/
	this.colocarInformacionFactura=function(){
		var _this=this;
		/*Validador*/
		var reglasDocInfo={};
		/*Facturacion con CCF*/
		if(!$("#pago-credito-doc-fac-pago").is(":disabled") && $("#pago-credito-doc-fac-pago").val()==2){
			 reglasDocInfo.clienteNRC=this.validadorFacturaInfo.clienteNRC();
		}
		/*Venta mayor a 200 Factura*/
		if(!$("#pago-credito-doc-fac-pago").is(":disabled") && parseFloat($('#documentos-pagar-totales tr.total-total-wrapper td.data-total').attr('data-totaltrans'))>=200.00 && $("#pago-credito-doc-fac-pago").val()==1){
			reglasDocInfo.clienteDUI=this.validadorFacturaInfo.clienteDUIoNIT();
		}
		/*Venta mayor a 200 Ticket*/
		if(!$("#pago-credito-doc-fac-pago").is(":disabled") && parseFloat($('#documentos-pagar-totales tr.total-total-wrapper td.data-total').attr('data-totaltrans'))>=200.00 && $("#pago-credito-doc-fac-pago").val()==3){
			reglasDocInfo.clienteDUI=this.validadorFacturaInfo.clienteDUIoNIT();
		}
		var valid=true;
		$.each(reglasDocInfo,function(i,reglaDocInfo){
			if(!reglaDocInfo.result){
				valid=reglaDocInfo.result;
				if(reglaDocInfo.msg)
					_this.showMsgPagoCredito('error',reglaDocInfo.msg);
				if(reglaDocInfo.action)
					reglaDocInfo.action();
			}
		});
		
		if(valid)
			$("#"+this.windowsId+" #pago-credito-info-docs").modal("hide");
	},
	/*Calcular totales*/
	this.calcTotal=function(){
		var docspagar=$("#pago-credito-doc-pagar").find(".documento-pagar-panel");
		var totalFacGrabado=0;
		var totalTranGrabado=0;
		var totalGrabado=0;
		
		var totalFacExento=0;
		var totalTranExento=0;
		var totalExento=0;
		
		var totalFacNoSujeto=0;
		var totalTranNoSujeto=0;
		var totalNoSujeto=0;
		
		var totalIva=0;
		var totalIvaFac=0;
		var totalRetencion=0;
		var totalRetencionFac=0;
		var totalPercepcion=0;
		var totalPercepcionFac=0;
		var totalImpuestos=0;
		var total=0;
		$.each(docspagar,function(i,doc){
			var items=$(doc).find(".panel-collapse table.documentopagar-items > tbody > tr");
			$.each(items,function(ii,item){
				var $item=$(item);
				switch(parseInt($item.attr("data-tipo"))){
					case 0:/*Grabado*/
						if($(doc).attr('data-doc')==1 || $(doc).attr('data-doc')==2 || $(doc).attr('data-doc')==3)
							totalFacGrabado+=parseFloat($item.find(".item-total-field").attr('data-value'))+parseFloat($(item).find(".item-total-field").attr('data-iva'))-parseFloat($(item).find(".item-total-field").attr('data-retencion'))+parseFloat($(item).find(".item-total-field").attr('data-percepcion'));
						else{
							totalTranGrabado+=parseFloat($item.find(".item-total-field").attr('data-value'))+parseFloat($(item).find(".item-total-field").attr('data-iva'))-parseFloat($(item).find(".item-total-field").attr('data-retencion'))+parseFloat($(item).find(".item-total-field").attr('data-percepcion'));
							totalIvaFac+=parseFloat($(item).find(".item-total-field").attr('data-iva'));
							totalRetencionFac+=parseFloat($(item).find(".item-total-field").attr('data-retencion'));
							totalPercepcionFac+=parseFloat($(item).find(".item-total-field").attr('data-percepcion'));
						}
						totalGrabado+=parseFloat($item.find(".item-total-field").attr('data-value'));
					break;
					case 1: case 3:/*Exento*/
						if($(doc).attr('data-doc')==1 || $(doc).attr('data-doc')==2 || $(doc).attr('data-doc')==3)
							totalFacExento+=parseFloat($item.find(".item-total-field").attr('data-value'))+parseFloat($(item).find(".item-total-field").attr('data-iva'))-parseFloat($(item).find(".item-total-field").attr('data-retencion'))+parseFloat($(item).find(".item-total-field").attr('data-percepcion'));
						else
							totalTranExento+=parseFloat($item.find(".item-total-field").attr('data-value'))+parseFloat($(item).find(".item-total-field").attr('data-iva'))-parseFloat($(item).find(".item-total-field").attr('data-retencion'))+parseFloat($(item).find(".item-total-field").attr('data-percepcion'));
						totalExento+=parseFloat($item.find(".item-total-field").attr('data-value'));
					break;
					case 2:/*No sujeto*/
						if($(doc).attr('data-doc')==1 || $(doc).attr('data-doc')==2 || $(doc).attr('data-doc')==3)
							totalFacNoSujeto+=parseFloat($item.find(".item-total-field").attr('data-value'))+parseFloat($(item).find(".item-total-field").attr('data-iva'))-parseFloat($(item).find(".item-total-field").attr('data-retencion'))+parseFloat($(item).find(".item-total-field").attr('data-percepcion'));
						else
							totalTranNoSujeto+=parseFloat($item.find(".item-total-field").attr('data-value'))+parseFloat($(item).find(".item-total-field").attr('data-iva'))-parseFloat($(item).find(".item-total-field").attr('data-retencion'))+parseFloat($(item).find(".item-total-field").attr('data-percepcion'));
						totalNoSujeto+=parseFloat($item.find(".item-total-field").attr('data-value'));
					break;
				}
				totalIva+=parseFloat($(item).find(".item-total-field").attr('data-iva'));
				totalRetencion+=parseFloat($(item).find(".item-total-field").attr('data-retencion'));
				totalPercepcion+=parseFloat($(item).find(".item-total-field").attr('data-percepcion'));
				
				totalImpuestos+=(parseFloat($(item).find(".item-total-field").attr('data-iva'))-parseFloat($(item).find(".item-total-field").attr('data-retencion'))+parseFloat($(item).find(".item-total-field").attr('data-percepcion')));
				
				total+=(parseFloat($(item).find(".item-total-field").attr('data-value'))+parseFloat($(item).find(".item-total-field").attr('data-iva'))-parseFloat($(item).find(".item-total-field").attr('data-retencion'))+parseFloat($(item).find(".item-total-field").attr('data-percepcion')));
			}); 
		});
		/**/
		$("#documentos-pagar-totales > table > tbody > tr.total-totalneto-wrapper td.data-total").attr("data-grabado",totalGrabado.toFixed(2));
		$("#documentos-pagar-totales > table > tbody > tr.total-totalneto-wrapper td.data-total").attr("data-exento",totalExento.toFixed(2));
		$("#documentos-pagar-totales > table > tbody > tr.total-totalneto-wrapper td.data-total").attr("data-nosujeto",totalNoSujeto.toFixed(2));
		$("#documentos-pagar-totales > table > tbody > tr.total-totalneto-wrapper td.data-total").attr("data-grabadofac",totalTranGrabado.toFixed(2));
		$("#documentos-pagar-totales > table > tbody > tr.total-totalneto-wrapper td.data-total").attr("data-exentofac",totalTranExento.toFixed(2));
		$("#documentos-pagar-totales > table > tbody > tr.total-totalneto-wrapper td.data-total").attr("data-nosujetofac",totalTranNoSujeto.toFixed(2));
		$("#documentos-pagar-totales > table > tbody > tr.total-totalneto-wrapper td.data-total").attr("data-value",(totalGrabado+totalExento+totalNoSujeto).toFixed(2));
		$("#documentos-pagar-totales > table > tbody > tr.total-totalneto-wrapper td.data-total").text((totalGrabado+totalExento+totalNoSujeto).toFixed(2));
		/**/
		$("#documentos-pagar-totales > table > tbody > tr.total-impuestos-wrapper td.data-total").attr("data-iva",totalIva.toFixed(2));
		$("#documentos-pagar-totales > table > tbody > tr.total-impuestos-wrapper td.data-total").attr("data-rentencion",totalRetencion.toFixed(2));
		$("#documentos-pagar-totales > table > tbody > tr.total-impuestos-wrapper td.data-total").attr("data-percepcion",totalPercepcion.toFixed(2));
		$("#documentos-pagar-totales > table > tbody > tr.total-impuestos-wrapper td.data-total").attr("data-ivafac",totalIvaFac.toFixed(2));
		$("#documentos-pagar-totales > table > tbody > tr.total-impuestos-wrapper td.data-total").attr("data-rentencionfac",totalRetencionFac.toFixed(2));
		$("#documentos-pagar-totales > table > tbody > tr.total-impuestos-wrapper td.data-total").attr("data-percepcionfac",totalPercepcionFac.toFixed(2));
		$("#documentos-pagar-totales > table > tbody > tr.total-impuestos-wrapper td.data-total").attr("data-value",totalImpuestos.toFixed(2));
		$("#documentos-pagar-totales > table > tbody > tr.total-impuestos-wrapper td.data-total").text(totalImpuestos.toFixed(2));
		/**/
		$("#documentos-pagar-totales > table > tbody > tr.total-total-wrapper td.data-total").attr("data-totalfac",(parseFloat(totalFacGrabado)+parseFloat(totalFacExento)+parseFloat(totalFacNoSujeto)).toFixed(2));
		$("#documentos-pagar-totales > table > tbody > tr.total-total-wrapper td.data-total").attr("data-totaltrans",(parseFloat(totalTranGrabado)+parseFloat(totalTranExento)+parseFloat(totalTranNoSujeto)).toFixed(2));
		$("#documentos-pagar-totales > table > tbody > tr.total-total-wrapper td.data-total").attr("data-value",total.toFixed(2));
		$("#documentos-pagar-totales > table > tbody > tr.total-total-wrapper td.data-total").text(total.toFixed(2));
		/**/
		
		
	}
	/**/
	this.validarPagoCredito=function($sender){
		if($sender){
			$sender.attr('disabled','disabled');
		}
		var _this=this;
		var reglas={items:this.validador.items(),numdoc:this.validador.numdoc()}
		var reglasTipo1=1;
		var reglasTipo2=1;
		var reglasTipo3=0;
		var reglasTipo4=0;
	 	/*Facturacion numero de documento vacio*/
		if(!$("#pago-credito-numdoc-fac-pago").is(":disabled")){
			reglas.facnumdoc=this.validador.facnumdoc();
			reglasTipo2+=1;
		}
		/*Facturacion con CCF*/
		if(!$("#pago-credito-doc-fac-pago").is(":disabled") && $("#pago-credito-doc-fac-pago").val()==2){
			reglas.clienteNRC=this.validador.clienteNRC();
			reglasTipo3+=1;
		}
		/*Venta mayor a 200 Factura*/
		if(!$("#pago-credito-doc-fac-pago").is(":disabled") && parseFloat($('#documentos-pagar-totales tr.total-total-wrapper td.data-total').attr('data-totaltrans'))>=200.00 && $("#pago-credito-doc-fac-pago").val()==1){
			reglas.clienteDUI=this.validador.clienteDUIoNIT();
			reglasTipo3+=1;
		}
		/*Venta mayor a 200 Ticket*/
		if(!$("#pago-credito-doc-fac-pago").is(":disabled") && parseFloat($('#documentos-pagar-totales tr.total-total-wrapper td.data-total').attr('data-totaltrans'))>=200.00 && $("#pago-credito-doc-fac-pago").val()==3){
			reglas.clienteDUI=this.validador.clienteDUIoNIT();
			reglasTipo3+=1;
		}
		if($("#pago-credito-forma-pago-select").val()==1){
			reglas.formaPagoEfectivo=this.validador.formaPagoEfectivo();
			reglas.formaPagoEfectivoValido=this.validador.formaPagoEfectivoValido();
			reglasTipo4=2;
		}
		var valid=true;
		var reglasCountTipo1=0;
		var reglasCountTipo2=0;
		var reglasCountTipo3=0;
		var reglasCountTipo4=0;
		var errorInType=null;
		$.each(reglas,function(i,regla){
			if(regla.type){
				if(regla.type==1)
					reglasCountTipo1+=1;
				else if(regla.type==2)
					reglasCountTipo2+=1;
				else if(regla.type==3)
					reglasCountTipo3+=1;
				else if(regla.type==4)
					reglasCountTipo4+=1;
			}
			if(!regla.result){
				valid=regla.result;
				if(regla.msg)
					_this.showMsgPagoCredito('error',regla.msg);
				if(regla.action)
					regla.action();
				if(regla.type)
					errorInType=regla.type;
			}else{
				if(reglasCountTipo2==reglasTipo2)
					$('#pago-credito-info-wrapper').modal("hide");	
				if(reglasCountTipo3==reglasTipo3)
					$('#pago-credito-cliente-docs').modal("hide");
				if(reglasCountTipo4==reglasTipo4)
					$('#pago-credito-forma-pago').modal("hide");	
			}
			return valid;
		});
		
		if(valid){
			$("#pago-credito-confirm-total").text(parseFloat($('#documentos-pagar-totales .total-total-wrapper .data-total').attr('data-value')));
			if($.trim($("#pago-credito-forma-pago-select").val())==1){
				$("#pago-credito-confirm-efectivo").text(parseFloat($("#pago-credito-forma-pago-efectivo").val()).toFixed(2));
				$("#pago-credito-confirm-cambio").text(parseFloat($("#pago-credito-forma-pago-cambio").val()).toFixed(2));
				$(".pago-credito-confirm-efectivo-table").show();
			}else{
				$(".pago-credito-confirm-efectivo-table").hide();
			}
			$('#pago-credito-confirmar').on('shown.bs.modal', function () {
				$("#pago-credito-confirmar-guardar-btn").focus();
			});
			$("#pago-credito-confirmar").modal({backdrop: 'static', keyboard: false});
			$("#pago-credito-confirmar").modal("show");
		}
		else{
			if(errorInType==1)
				$("#guardar-pago-credito-btn").removeAttr('disabled');
			else if(errorInType==2)
				$("#pago-credito-info-guardar").removeAttr('disabled');
			else if(errorInType==3)
				$("#pago-credito-cliente-docs-guardar-btn").removeAttr('disabled');
			else if(errorInType==4)
				$("#pago-credito-fpago-guardar-btn").removeAttr('disabled');
		}
	},
	this.processPago=function(){
		var _this=this;
		$("#pago-credito-confirmar-guardar-btn").attr('disabled','disabled');
		$("#pago-credito-cancelar-guardar-btn").attr('disabled','disabled');
		$("#pago-credito-procesar-status-text").text('Guardando venta...');
		$("#pago-credito-procesar-status-icon").html("<i class='fa fa-spinner fa-5x'></i>");
		var docspagar=$("#pago-credito-doc-pagar").find(".documento-pagar-panel");
		var docs=[];
		var productsFac=[];	
		var totales=[];
		var totaliva=0;
		$.each(docspagar,function(i,doc){
			if(($(doc).attr("data-doc")=='0' || $(doc).attr("data-doc")=='4' || $(doc).attr("data-doc")=='5') && $("#pago-credito-fac-transito").is(":checked")){
				var items=$(doc).find(".panel-collapse table.documentopagar-items > tbody > tr");
				$.each(items,function(ii,item){
					var $item=$(item);
					var costo=$item.find("td.item-total-field").attr("data-value");
					var cant=$item.find("td.item-cant-field").attr('data-value');
					if($('#pago-credito-doc-fac-pago').val()=='2' && $item.attr("data-tipo")=='0'){
						costo=(costo/1.13);
						totaliva+=costo*0.13;
					}
					productsFac.push({idsalida:$item.attr("data-salida"),cant:cant,desc:$item.find("td.item-desc-field").attr("data-value"),costo:(costo/cant).toFixed(4),tipoventa:$item.attr("data-tipo"),interno:$item.attr("data-interno")});
				});	
			}			
			docs.push({idventa:$(doc).attr("id").split("-")[1],vendedor:$(doc).attr("data-vendedor"),doc:$(doc).attr("data-doc"),numdoc:$(doc).attr("data-numdoc"),condicion:$(doc).attr("data-condicion"),credito:$(doc).attr("data-credito"),total:$(doc).attr('data-total')});
		});
		var totalGrabado=$("#documentos-pagar-totales table > tbody > tr.total-totalneto-wrapper > td.data-total").attr('data-grabado');
		if($('#pago-credito-doc-fac-pago').val()=='2'){
			totalGrabado=(parseFloat(totalGrabado)/1.13).toFixed(2);
		}
		totales.push({totalGrabadas:totalGrabado});
		totales.push({totalIVA:totaliva.toFixed(2)});
		totales.push({totalIVApercibido:$("#documentos-pagar-totales > table > tbody > tr.total-impuestos-wrapper > td.data-total").attr("data-percepcionfac")});
		totales.push({totalIVAretenido:$("#documentos-pagar-totales > table > tbody > tr.total-impuestos-wrapper > td.data-total").attr("data-rentencionfac")});
		totales.push({totalNS:$("#documentos-pagar-totales table > tbody > tr.total-totalneto-wrapper > td.data-total").attr('data-nosujetofac')});
		totales.push({totalExento:$("#documentos-pagar-totales table > tbody > tr.total-totalneto-wrapper > td.data-total").attr('data-exentofac')});
		totales.push({totalTotal:$("#documentos-pagar-totales table > tbody > tr.total-total-wrapper > td.data-total").attr('data-totaltrans')});
		
		$.post(_this.baseUrl+'transacciones/guardarpagocredito',{
			"factura[cliente]":$("#pago-credito-info-docs-cliente").val(),
			"factura[fecha]":$("#pago-credito-info-docs-fecha").val(),
			"factura[direccion]":$("#pago-credito-info-docs-direccion").val(),
			"factura[dui]":$("#pago-credito-info-docs-dui").val(),
			"factura[nit]":$("#pago-credito-info-docs-nit").val(),
			"factura[nrc]":$("#pago-credito-info-docs-nrc").val(),
			"factura[giro]":$("#pago-credito-info-docs-giro").val(),
			cliente:$('#pago-credito-cliente').val(),
			clientetxt:$.trim($("#pago-credito-cliente option:selected").attr("data-nombre")),
			clientedui:$.trim($("#pago-credito-cliente-dui").val()),
			clientenit:$.trim($("#pago-credito-cliente-nit").val()),
			clientenrc:$.trim($("#pago-credito-cliente-nrc").val()),
			docp:$('#pago-credito-doc-pago').val(),
			seriep:$("#pago-credito-doc-serie-pago").val(),
			serieidp:$("#pago-credito-doc-serie-pago option:selected").attr("data-id"),
			nump:$('#pago-credito-numdoc-pago').val(),
			fpago:$("#pago-credito-forma-pago-select").val(),
			docs:JSON.stringify(docs),
			total:$("#documentos-pagar-totales > table > tbody > tr.total-total-wrapper > td.data-total").attr("data-value"),
			facturar:$("#pago-credito-fac-transito").is(":checked"),
			docf:$('#pago-credito-doc-fac-pago').val(),
			serief:$("#pago-credito-doc-fac-serie-pago").val(),
			serieidf:$("#pago-credito-doc-fac-serie-pago option:selected").attr("data-id"),
			numf:$('#pago-credito-numdoc-fac-pago').val(),
			productos:JSON.stringify(productsFac),
			totales:JSON.stringify(totales),
		})
		.done(function(saved){
			if(saved){
				$("#pago-credito-procesar-status-text").text('¡El pago se ha guardado!');
				$("#pago-credito-procesar-status-icon").html("<i style='color:#1AB394;' class='fa fa-check-circle fa-5x'></i>");
				$("#pago-credito-cancelar-guardar-btn").hide();
				$("#pago-credito-confirmar-guardar-btn").hide();
				$("#pago-credito-confirmar-salir-btn").show();
				$("#pago-credito-confirmar-salir-btn").focus();
			}
		});
	},
	this.cancelarPagoCredito=function(){
		$("#pago-credito-numdoc-pago").val("");
		$("#pago-credito-forma-pago-select").val(1);
		$("#pago-credito-efectivo-frame").show();
		$("#pago-credito-forma-pago-efectivo").val("");
		$("#guardar-pago-credito-btn").removeAttr('disabled');
		$("#pago-credito-info-guardar").removeAttr('disabled');
		$("#pago-credito-fpago-guardar-btn").removeAttr('disabled');
		$("#pago-credito-confirmar-guardar-btn").removeAttr('disabled');
		$("#"+this.windowsId+" #pago-credito-doc-fac-pago").prop("disabled","disabled");
		$("#"+this.windowsId+" #pago-credito-doc-fac-serie-pago").prop("disabled","disabled");
		$("#"+this.windowsId+" #pago-credito-numdoc-fac-pago").prop("disabled","disabled");
		$("#"+this.windowsId+" #pago-credito-fac-info-wrapper").hide();
		$("#"+this.windowsId+" #pago-credito-fac-transito").prop("checked",true);
	},
	/*Autocompletar serie y numero de documento*/
	this.setAutoNumDoc=function(doc,useFirst,$serieWrapper,$numWrapper){
		var _this=this;
		$serieWrapper.find("option").remove()
		$numWrapper.val("");
		$.get(this.baseUrl+"administracion/resolucionesxdoc",{doc:doc,caja:this.caja,activas:true},function(series){
			if(series){
				$.each(series,function(i,serie){
					$serieWrapper.append($('<option>',{ 
						value:serie.serie,
						'data-id':serie.id,
						'data-act':serie.actual,
						text:serie.serie 
					}));
				});
				$serieWrapper.find("option:first").attr('selected','selected');
				if(useFirst)
					$numWrapper.val($serieWrapper.find(" option:selected").attr("data-act"));
			}
		},'json');
	},
	this.validador={
		items:function(){
			return {
				result:$("#pago-credito-doc-pagar").find(".documento-pagar-panel").size()>0,
				msg:"Por favor agregue productos a la items a la lista de documentos a pagar",
				type:1
			}
		},
		numdoc:function(){
			return {
				result:($.trim($("#pago-credito-numdoc-pago").val())!=''?true:false),
				msg:"Por favor ingrese el n&uacute;mero de documento",
				type:2,
				action:function(){
					$('#pago-credito-info-wrapper').on('shown.bs.modal', function(){
						$("#pago-credito-numdoc-pago").focus();
					});
					$('#pago-credito-info-wrapper').modal("show");
					$("#pago-credito-numdoc-pago").focus();
				}
			}
		},
		facnumdoc:function(){
			return {
				result:($.trim($("#pago-credito-numdoc-fac-pago").val())!=''?true:false),
				msg:"Por favor ingrese el n&uacute;mero de documento de facturaci&oacute;n",
				type:2,
				action:function(){
					$('#pago-credito-info-wrapper').on('shown.bs.modal', function(){
						$("#pago-credito-numdoc-fac-pago").focus();
					});
					$('#pago-credito-info-wrapper').modal("show");
					$("#pago-credito-numdoc-fac-pago").focus();
				}
			}
		},
		clienteNRC:function(){
			return {
				result:($.trim($("#pago-credito-cliente-nrc").val())!=""?true:false),
				msg:"Por favor ingrese el N&uacute;mero de Registro Comercial (NRC)",
				type:3,
				action:function(){
					$('#pago-credito-cliente-docs').on('shown.bs.modal', function () {
						$("#pago-credito-cliente-nrc").focus();
					});
					$('#pago-credito-cliente-docs').modal("show");
					$("#pago-credito-cliente-nrc").focus();
				}
			}
		},
		clienteDUIoNIT:function(){
			return {
				result:($.trim($("#pago-credito-cliente-dui").inputmask('unmaskedvalue')).length == 9 || $.trim($("#pago-credito-cliente-nit").inputmask('unmaskedvalue')).length == 14?true:false),
				msg:"Por favor ingrese el N&uacute;mero de Documento Unico de Identidad (DUI) 0 el N&uacute;mero de Identificaci&oacute;n tributaria (NIT) v&aacute;lido",
				type:3,
				action:function(){
					$('#pago-credito-cliente-docs').on('shown.bs.modal', function () {
						$("#pago-credito-cliente-dui").focus();
					});
					$('#pago-credito-cliente-docs').modal("show");
					$("#pago-credito-cliente-dui").focus();
				}
			}
		},
		formaPagoEfectivo:function(){
			return {
				result:($.trim($("#pago-credito-forma-pago-efectivo").val())!=''?true:false),
				type:4,
				msg:"por favor ingrese la cantidad de efectivo para esta venta",
				action:function(){
					$("#pago-credito-forma-pago-total").text("$"+parseFloat($('#documentos-pagar-totales .total-total-wrapper .data-total').attr('data-value')));
					$('#pago-credito-forma-pago').on('shown.bs.modal', function () {
						$("#pago-credito-forma-pago-efectivo").focus();
					});
					$('#pago-credito-forma-pago').modal("show");
					$("#pago-credito-forma-pago-efectivo").focus();
				}
			}
		},
		formaPagoEfectivoValido:function(){
			return {
				result:($.trim($("#pago-credito-forma-pago-efectivo").val())>=parseFloat($('#documentos-pagar-totales .total-total-wrapper .data-total').attr('data-value'))?true:false),
				type:4,
				msg:"El efectivo no puede ser menor que el total de la venta, por favor verifique.",
				action:function(){
					$("#pago-credito-forma-pago-efectivo").select();
				}
			}
		}
	}
	this.validadorFacturaInfo={
		clienteNRC:function(){
			return {
				result:($.trim($("#pago-credito-info-docs-nrc").val())!=""?true:false),
				msg:"Por favor ingrese el N&uacute;mero de Registro Comercial (NRC)",
				action:function(){
					$("#pago-credito-info-docs-nrc").focus();
				}
			}
		},
		clienteDUIoNIT:function(){
			return {
				result:($.trim($("#pago-credito-info-docs-dui").inputmask('unmaskedvalue')).length == 9 || $.trim($("#pago-credito-info-docs-nit").inputmask('unmaskedvalue')).length == 14?true:false),
				msg:"Por favor ingrese el N&uacute;mero de Documento Unico de Identidad (DUI) 0 el N&uacute;mero de Identificaci&oacute;n tributaria (NIT) v&aacute;lido",
				action:function(){
					$("#pago-credito-info-docs-dui").focus();
				}
			}
		},
	}
	this.showMsgPagoCredito=function(tipo, mensaje){
		toastr.options = {
			"closeButton": true,
			"progressBar": true,
			"positionClass": "toast-top-right"
		}
		toastr[tipo](mensaje);
	}
}