var Clientes=function(){
	this.baseUrl=null;
	this.scroll=true;
	this.test=function(){
		console.log('La clase Clientes ha sido instanciado correctamente');
	}
	this.setUrl=function(url){
		this.baseUrl=url;
	}
	this.guardar=function(e,action){
		e.preventDefault();
		var $form=$(e.target);
		$form.find(":submit").prop('disabled', true);
		var _this=this;
		var clienteID=null;
		$form.ajaxSubmit({
			success:function(response){
				if(response=="1"){
					toastr.options = {
					  "closeButton": true,
					  "progressBar": true,
					  "positionClass": "toast-top-right"
					}
					toastr.success('El cliente se ha registrado en la base de datos del sistema');
					if(action=='update'){
						_this.detalles($("#nuevo-clientes-id").val());
					}else{
						$("#clientes-search-str").val($form.find("#nombre_cliente").val());
						_this.cargarHTML(true,0);
					}
					Custombox.close(); 
				}else{
					toastr.options = {
					  "closeButton": true,
					  "progressBar": true,
					  "positionClass": "toast-top-right"
					}
					toastr.error('&iexcl;Ha ocurrido un error! <br/> La accion NO se ha completado');
					Custombox.close(); 
				}
			}
		});
	}
	this.cargarJSON=function(reset,offset){
		if(this.scroll){
			this.scroll=false;
			this.loader($('#clientes-lista-table tbody tr.tr-loader td:first'),'start');
			if(reset){
				$("#clientes-lista-table").find("tr:not(.tr-loader)").remove();
			}
			jQuery.ajaxSetup({async:false});
			$.get(this.baseUrl+"clientes/cargar",{search:$('#clientes-search-str').val(),offset:offset},function(clientes){
				if(clientes){
					$.each(clientes,function(i,cliente){
						var clienteHtml="<tr id='cliente-"+cliente.id+"' data-clasificacion='"+cliente.clasificacion+"' data-credito='"+cliente.credito+"' data-dui='"+cliente.dui+"' data-nit='"+cliente.nit+"' data-nrc='"+cliente.nrc+"'><td><h4 class='noselecttext'>"+cliente.nombre+"</h4><small class='noselecttext'>"+cliente.razon+"</small></td><td class='contact-type noselecttext'><i class='fa fa-phone'></i></td><td class='noselecttext'> "+cliente.tel+"</td></tr>"
						$(clienteHtml).insertBefore('.tr-loader');
					});
				}else{
					toastr.options = {
					  "closeButton": true,
					  "positionClass": "toast-bottom-right"
					}
					toastr.warning('&iexcl;No se han encontrado más clientes en la base de datos del sistema!');
				}
			},"json");
			this.loader($('#clientes-lista-table tbody tr.tr-loader td:first'),'stop');
			this.scroll=true;
		}
	}
	this.cargarHTML=function(reset,offset){
		if(this.scroll){
			var _this =this;
			this.scroll=false;
			if(reset){
				$("#clientes-lista-table").find("tr:not(.tr-loader)").remove();
			}
			$.get(this.baseUrl+"clientes/cargarhtml",{search:$('#clientes-search-str').val(),offset:offset},function(clientes){
				if(clientes!=''){
					var html=$("#clientes-lista-table > tbody").html()+clientes;
					$("#clientes-lista-table tbody").html(html);	
					if(reset){
						$("#clientes-lista-table tbody tr:first").addClass("miracle-selected-table-item");
					}
					_this.scroll=true;
				}else{
					_this.scroll=true;
				}
			},"html");
		}
	}
	this.detalles=function(id){
		$("#clientes-detalles-ajax-wrapper").html('');
		this.loader($('#clientes-detalles-ajax-wrapper'),'start');
		$("#clientes-detalles-info-wrapper").hide();
		$.get(this.baseUrl+"clientes/detalles",{id:id},function(cliente){
			$("#clientes-detalles-ajax-wrapper").html(cliente);
		},"html");
	}
	this.eliminar=function(id,nombre){
		var _this=this;
		swal({
		  title: "¿Eliminar "+nombre+"?",
		  text: "Esta acción eliminará definitivamente al cliente. ¿Esta seguro que desea continuar?",
		  type: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#DD6B55",
		  cancelButtonText: "Cancelar",
		  confirmButtonText: "Si, Eliminar"
		},
		function(){
			$.get(_this.baseUrl+"clientes/eliminar",{id:id},function(deleted){
				if(deleted){
					toastr.options = {
					  "closeButton": true,
					  "progressBar": true,
					  "positionClass": "toast-top-right"
					}
					toastr.success('El cliente <b>'+nombre+'</b> se ha eliminado.');
					$("#clientes-detalles-ajax-wrapper").html('');
					$("#clientes-detalles-info-wrapper").show();
					_this.cargar(true,0);
				}
			},'text');
		});
	}
	this.loader=function($wrapper,action){
		if(action=='start'){
			$wrapper.show();
			var load=$(document.createElement('div')).attr('class','sk-spinner sk-spinner-fading-circle');
			for(var i=1; i<=12; i++){
				$(document.createElement('div')).attr('class','sk-circle'+i+' sk-circle').appendTo(load);
			}
			load.appendTo($wrapper);
		}else if('stop'){
			$wrapper.hide();
			$wrapper.find('.sk-spinner').remove();
		}
	}
}
var clientes = new Clientes();