<div class="row">
	<div class="col-lg-6">
		<div class="ibox float-e-margins">
			<div class="ibox-title">
				<h5>Salidas por da&ntilde;o o vencimiento</h5>
				<div class="ibox-tools">
					<a class="collapse-link">
						<i class="fa fa-chevron-up"></i>
					</a>
				</div>
			</div>
			<div class="ibox-content">
				<div class="row">
					<div class="col-lg-12">
						<div class="row"><!--Vencimiento-->
							<div class="col-sm-4">
								<label>Desde</label>
								<input type="text" class="form-control" id="reportes-vencimiento-desde-days" readonly>
							</div>
							<div class="col-sm-4">
								<label>Hasta</label>
								<input type="text" class="form-control" id="reportes-vencimiento-hasta-days" readonly>
							</div>
							<div class="col-sm-4">
								<button class="btn btn-danger m-t-md" id="construirReporteVencimiento"><i class="fa fa-file-pdf-o"></i> Exportar</button>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="col-lg-6">
		<div class="ibox float-e-margins">
			<div class="ibox-title">
				<h5>Salidas perdida o extrav&iacute;o</h5>
				<div class="ibox-tools">
					<a class="collapse-link">
						<i class="fa fa-chevron-up"></i>
					</a>
				</div>
			</div>
			<div class="ibox-content">
				<div class="row">
					<div class="col-lg-12">
						<div class="row"><!--Compras-->
							<div class="col-sm-4">
								<label>Desde</label>
								<input type="text" class="form-control" id="reportes-perdida-desde-days" readonly>
							</div>
							<div class="col-sm-4">
								<label>Hasta</label>
								<input type="text" class="form-control" id="reportes-perdida-hasta-days" readonly>
							</div>
							<div class="col-sm-4">
								<button class="btn btn-danger m-t-md" id="construirReportePerdida"><i class="fa fa-file-pdf-o"></i> Exportar</button>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="col-lg-6">
		<div class="ibox float-e-margins">
			<div class="ibox-title">
				<h5>Salidas por devolici&oacute;n a proveedor</h5>
				<div class="ibox-tools">
					<a class="collapse-link">
						<i class="fa fa-chevron-up"></i>
					</a>
				</div>
			</div>
			<div class="ibox-content">
				<div class="row">
					<div class="col-lg-12">
						<div class="row"><!--Compras-->
							<div class="col-sm-4">
								<label>Desde</label>
								<input type="text" class="form-control" id="reportes-devolucion-desde-days" readonly>
							</div>
							<div class="col-sm-4">
								<label>Hasta</label>
								<input type="text" class="form-control" id="reportes-devolucion-hasta-days" readonly>
							</div>
							<div class="col-sm-4">
								<button class="btn btn-danger m-t-md" id="construirReporteDevolucion"><i class="fa fa-file-pdf-o"></i> Exportar</button>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="col-lg-6">
		<div class="ibox float-e-margins">
			<div class="ibox-title">
				<h5>Salidas por consumo interno</h5>
				<div class="ibox-tools">
					<a class="collapse-link">
						<i class="fa fa-chevron-up"></i>
					</a>
				</div>
			</div>
			<div class="ibox-content">
				<div class="row">
					<div class="col-lg-12">
						<div class="row"><!--Compras-->
							<div class="col-sm-4">
								<label>Desde</label>
								<input type="text" class="form-control" id="reportes-consumo-desde-days" readonly>
							</div>
							<div class="col-sm-4">
								<label>Hasta</label>
								<input type="text" class="form-control" id="reportes-consumo-hasta-days" readonly>
							</div>
							<div class="col-sm-4">
								<button class="btn btn-danger m-t-md" id="construirReporteConsumo"><i class="fa fa-file-pdf-o"></i> Exportar</button>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<script>
	$(document).ready(function(){
		/*Vencimiento*/
		$("#construirReporteVencimiento").on("click",function(){
			var valid = true;
			var fechadesde = "";
			var fechahasta = "";
			
			if($('#reportes-vencimiento-desde-days').val() == ""){
				$('#reportes-vencimiento-desde-days').focus();
				valid = false;
			}else if($('#reportes-vencimiento-hasta-days').val() == ""){
				$('#reportes-vencimiento-hasta-days').focus();
				valid = false;
			}else{
				fechadesde = $('#reportes-vencimiento-desde-days').val();
				fechahasta = $('#reportes-vencimiento-hasta-days').val();
			}
			
			if(valid){
				window.open('<?php echo base_url();?>reportes/reporte_vencimiento?fechadesde='+fechadesde+'&fechahasta='+fechahasta,'_blank');
			}else{
				toastr.options = {
				  "closeButton": true,
				  "progressBar": true,
				  "positionClass": "toast-top-right"
				}
				toastr.error('Hace falta informacion necesaria para enviar el formulario, favor verifique');
			}		
		});
		
		var inicio_vencimiento_diario = $('#reportes-vencimiento-desde-days').datepicker({
			language:'es',
			format:'yyyy-mm-dd',
			autoclose:true
		}).on('changeDate', function (ev) {
				var newDate = new Date(ev.date);
				if(!isNaN(newDate)){
					newDate.setDate(newDate.getDate());
					fin_vencimiento_diario.datepicker("update", newDate);
					$('#reportes-vencimiento-hasta-days')[0].focus();
				}
		});
		var fin_vencimiento_diario = $('#reportes-vencimiento-hasta-days').datepicker({
			language:'es',
			format:'yyyy-mm-dd',
			beforeShowDay: function (date) {
				if (!inicio_vencimiento_diario.datepicker("getDate").valueOf()) {
					return date.valueOf() >= new Date().valueOf();
				} else {
					return date.valueOf() > inicio_vencimiento_diario.datepicker("getDate").valueOf()-1;
				}
			},
			autoclose: true

		}).on('changeDate', function (ev) {});
		
		/*Perdida*/
		$("#construirReportePerdida").on("click",function(){
			var valid = true;
			var fechadesde = "";
			var fechahasta = "";
			
			if($('#reportes-perdida-desde-days').val() == ""){
				$('#reportes-perdida-desde-days').focus();
				valid = false;
			}else if($('#reportes-perdida-hasta-days').val() == ""){
				$('#reportes-perdida-hasta-days').focus();
				valid = false;
			}else{
				fechadesde = $('#reportes-perdida-desde-days').val();
				fechahasta = $('#reportes-perdida-hasta-days').val();
			}
			
			if(valid){
				window.open('<?php echo base_url();?>reportes/reporte_perdida?fechadesde='+fechadesde+'&fechahasta='+fechahasta,'_blank');
			}else{
				toastr.options = {
				  "closeButton": true,
				  "progressBar": true,
				  "positionClass": "toast-top-right"
				}
				toastr.error('Hace falta informacion necesaria para enviar el formulario, favor verifique');
			}		
		});
		
		var inicio_perdida_diario = $('#reportes-perdida-desde-days').datepicker({
			language:'es',
			format:'yyyy-mm-dd',
			autoclose:true
		}).on('changeDate', function (ev) {
				var newDate = new Date(ev.date);
				if(!isNaN(newDate)){
					newDate.setDate(newDate.getDate());
					fin_perdida_diario.datepicker("update", newDate);
					$('#reportes-perdida-hasta-days')[0].focus();
				}
		});
		var fin_perdida_diario = $('#reportes-perdida-hasta-days').datepicker({
			language:'es',
			format:'yyyy-mm-dd',
			beforeShowDay: function (date) {
				if (!inicio_perdida_diario.datepicker("getDate").valueOf()) {
					return date.valueOf() >= new Date().valueOf();
				} else {
					return date.valueOf() > inicio_perdida_diario.datepicker("getDate").valueOf()-1;
				}
			},
			autoclose: true

		}).on('changeDate', function (ev) {});
		
		/*Devoluciones a Proveedor*/
		$("#construirReporteDevolucion").on("click",function(){
			var valid = true;
			var fechadesde = "";
			var fechahasta = "";
			
			if($('#reportes-devolucion-desde-days').val() == ""){
				$('#reportes-devolucion-desde-days').focus();
				valid = false;
			}else if($('#reportes-devolucion-hasta-days').val() == ""){
				$('#reportes-devolucion-hasta-days').focus();
				valid = false;
			}else{
				fechadesde = $('#reportes-devolucion-desde-days').val();
				fechahasta = $('#reportes-devolucion-hasta-days').val();
			}
			
			if(valid){
				window.open('<?php echo base_url();?>reportes/reporte_devoluciones_proveedor?fechadesde='+fechadesde+'&fechahasta='+fechahasta,'_blank');
			}else{
				toastr.options = {
				  "closeButton": true,
				  "progressBar": true,
				  "positionClass": "toast-top-right"
				}
				toastr.error('Hace falta informacion necesaria para enviar el formulario, favor verifique');
			}		
		});
		
		var inicio_devolucion_diario = $('#reportes-devolucion-desde-days').datepicker({
			language:'es',
			format:'yyyy-mm-dd',
			autoclose:true
		}).on('changeDate', function (ev) {
				var newDate = new Date(ev.date);
				if(!isNaN(newDate)){
					newDate.setDate(newDate.getDate());
					fin_devolucion_diario.datepicker("update", newDate);
					$('#reportes-devolucion-hasta-days')[0].focus();
				}
		});
		var fin_devolucion_diario = $('#reportes-devolucion-hasta-days').datepicker({
			language:'es',
			format:'yyyy-mm-dd',
			beforeShowDay: function (date) {
				if (!inicio_devolucion_diario.datepicker("getDate").valueOf()) {
					return date.valueOf() >= new Date().valueOf();
				} else {
					return date.valueOf() > inicio_devolucion_diario.datepicker("getDate").valueOf()-1;
				}
			},
			autoclose: true

		}).on('changeDate', function (ev) {});
		
		/*Consumo*/
		$("#construirReporteConsumo").on("click",function(){
			var valid = true;
			var fechadesde = "";
			var fechahasta = "";
			
			if($('#reportes-consumo-desde-days').val() == ""){
				$('#reportes-consumo-desde-days').focus();
				valid = false;
			}else if($('#reportes-consumo-hasta-days').val() == ""){
				$('#reportes-consumo-hasta-days').focus();
				valid = false;
			}else{
				fechadesde = $('#reportes-consumo-desde-days').val();
				fechahasta = $('#reportes-consumo-hasta-days').val();
			}
			
			if(valid){
				window.open('<?php echo base_url();?>reportes/reporte_consumo?fechadesde='+fechadesde+'&fechahasta='+fechahasta,'_blank');
			}else{
				toastr.options = {
				  "closeButton": true,
				  "progressBar": true,
				  "positionClass": "toast-top-right"
				}
				toastr.error('Hace falta informacion necesaria para enviar el formulario, favor verifique');
			}		
		});
		
		var inicio_consumo_diario = $('#reportes-consumo-desde-days').datepicker({
			language:'es',
			format:'yyyy-mm-dd',
			autoclose:true
		}).on('changeDate', function (ev) {
				var newDate = new Date(ev.date);
				if(!isNaN(newDate)){
					newDate.setDate(newDate.getDate());
					fin_consumo_diario.datepicker("update", newDate);
					$('#reportes-consumo-hasta-days')[0].focus();
				}
		});
		var fin_consumo_diario = $('#reportes-consumo-hasta-days').datepicker({
			language:'es',
			format:'yyyy-mm-dd',
			beforeShowDay: function (date) {
				if (!inicio_consumo_diario.datepicker("getDate").valueOf()) {
					return date.valueOf() >= new Date().valueOf();
				} else {
					return date.valueOf() > inicio_consumo_diario.datepicker("getDate").valueOf()-1;
				}
			},
			autoclose: true

		}).on('changeDate', function (ev) {});
	});
</script>