<?php
	$this->load->library('fpdf');
	
	$GLOBALS['dataArray'] = array(
        'Empresa' => $configs['NombreEmpresa'],
        'Direccion' => $configs['DireccionEmpresa'],
        'Logo' => base_url($configs['LogoEmpresa']),
        'Vendedor' => (isset($vendedor[0]->nombre_usuario))?$vendedor[0]->nombre_usuario:$vendedor,
        'Caja' => (isset($caja[0]->nombre_caja))?$caja[0]->nombre_caja:$caja,
		'FechaDesde' => $fecha_inicio,
        'FechaHasta' => $fecha_fin,
        'Condicion' => $condicion,
        'Metodo' => $metodo
    );
	
	class PDF extends FPDF{
    
        function Header(){
            global $dataArray;
			
			$fechadesde = new DateTime($dataArray['FechaDesde']);
			$fechahasta = new DateTime($dataArray['FechaHasta']);
			
            $this->Image($dataArray['Logo'],250,5,25);
            $this->SetFont('Arial','B',15);
            $this->SetY(6);
            $this->Cell(0,8,utf8_decode('Reporte de Ganancias'),0,1,'C');
            $this->SetFont('Arial','B',11);
            $this->SetY(12);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Empresa'])),0,1,'C');
            $this->SetY(17);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Direccion'])),0,1,'C');
            $this->Ln(3);
			
			$this->SetFont('Arial','',11);
            $this->Cell(20,8,'Periodo',0,0,'L');
			$this->SetFont('Arial','B',11);
            $this->Cell(60,8,$fechadesde->format('d-m-Y').' - '.$fechahasta->format('d-m-Y'),0,0,'L');
			
			$this->SetFont('Arial','',11);
            $this->Cell(20,8,'Condicion',0,0,'L');
			$this->SetFont('Arial','B',11);
            $this->Cell(60,8,utf8_decode($dataArray['Condicion']),0,0,'L');
			
			$this->SetFont('Arial','',11);
            $this->Cell(20,8,'Metodo',0,0,'L');
			$this->SetFont('Arial','B',11);
            $this->Cell(60,8,utf8_decode($dataArray['Metodo']),0,1,'L');
			
			$this->SetFont('Arial','',11);
            $this->Cell(20,8,'Vendedor',0,0,'L');
			$this->SetFont('Arial','B',11);
            $this->Cell(60,8,utf8_decode($dataArray['Vendedor']),0,0,'L');
			
			$this->SetFont('Arial','',11);
            $this->Cell(20,8,'Caja',0,0,'L');
			$this->SetFont('Arial','B',11);
            $this->Cell(60,8,$dataArray['Caja'],0,1,'L');
			
			$this->Ln(3);
			
            /*Header Tabla*/
            $this->SetFont('Arial','B',9);
            $this->Cell(15,8,'Ref V',1,0,'C');
            $this->Cell(30,8,'Fecha',1,0,'C');
            $this->Cell(50,8,'Documento',1,0,'C');
            $this->Cell(75,8,'Producto',1,0,'C');
            $this->Cell(15,8,'Cantidad',1,0,'C');
            $this->Cell(15,8,'Pre Neto',1,0,'C');
            $this->Cell(15,8,'Cos Neto',1,0,'C');
            $this->Cell(15,8,'Tot Venta',1,0,'C');
            $this->Cell(15,8,'Tot Costo',1,0,'C');
            $this->Cell(15,8,'Utilidad',1,1,'C');
            $this->SetFont('Arial','',8);
        }
		
        function Footer(){
            $this->SetY(-15);
            $this->SetFont('Arial','I',7);
            $this->Cell(200,6,utf8_decode('Pagina '.$this->PageNo().'/{nb}'),0,0,'L');
            $this->Cell(60,6,utf8_decode(gmdate('d-m-Y H:i:s', strtotime('- 6 hours'))),0,1,'R');
            $this->Cell(60,6,utf8_decode('Miracle v1.5 - Todos los Derechos Reservados 2012 - '.date('Y').' - Xypnos Soluciones Tecnologicas'),0,1,'L');
        }
    }
	
	$pdf = new PDF();
	$pdf->AliasNbPages(); 
	$pdf->setTitle('Reporte de Ganancias');
	$pdf->setAuthor('Miracle v1.5 - Xypnos');
	$pdf->AddPage('L','Letter');
	
	$ventasNetasTotales=0;
	$costosNetosTotales=0;
	$utilidadNetaTotales=0;
	if($productos){
		foreach($productos as $prodventa){
			$pdf->Cell(15,8,$prodventa->ref,1,0,'L');
            $pdf->Cell(30,8,$prodventa->fecha,1,0,'L');
            $pdf->Cell(50,8,$documentos[$prodventa->documento]["shortName"]." ".$prodventa->serie." ".$prodventa->numero,1,0,'L');
            $pdf->Cell(75,8,substr($prodventa->desc,0,43),1,0,'L');
            $pdf->Cell(15,8,$prodventa->cantidad,1,0,'R');
            $pdf->Cell(15,8,number_format(($prodventa->totalUnitaroEquivNeto*$prodventa->uequiv),4),1,0,'R');
            $pdf->Cell(15,8,number_format(($prodventa->costo*$prodventa->uequiv),4),1,0,'R');
            $pdf->Cell(15,8,number_format(($prodventa->totalUnitaroEquivNeto*$prodventa->uequiv)*$prodventa->cantidad,4),1,0,'R');
            $pdf->Cell(15,8,number_format(($prodventa->costo*$prodventa->uequiv)*$prodventa->cantidad,4),1,0,'R');
            $pdf->Cell(15,8,number_format((($prodventa->totalUnitaroEquivNeto*$prodventa->uequiv)*$prodventa->cantidad)-(($prodventa->costo*$prodventa->uequiv)*$prodventa->cantidad),4),1,1,'R');
			
			$ventasNetasTotales+=($prodventa->totalUnitaroEquivNeto*$prodventa->uequiv)*$prodventa->cantidad;
			$costosNetosTotales+=($prodventa->costo*$prodventa->uequiv)*$prodventa->cantidad;
			$utilidadNetaTotales+=(($prodventa->totalUnitaroEquivNeto*$prodventa->uequiv)*$prodventa->cantidad)-(($prodventa->costo*$prodventa->uequiv)*$prodventa->cantidad);
		}
		$pdf->SetFont('Arial','B',8);
		$pdf->Cell(170,8,"",0,0,'R');
		$pdf->Cell(45,8,"Total Ventas Netas",1,0,'L');
		$pdf->Cell(45,8,number_format($ventasNetasTotales,2),1,1,'R');
		$pdf->Cell(170,8,"",0,0,'R');
		$pdf->Cell(45,8,"Total Costos Netos",1,0,'L');
		$pdf->Cell(45,8,number_format($costosNetosTotales,2),1,1,'R');
		$pdf->Cell(170,8,"",0,0,'R');
		$pdf->Cell(45,8,"Total Utilidades",1,0,'L');
		$pdf->Cell(45,8,number_format($utilidadNetaTotales,2),1,1,'R');
	}
	
	$pdf->Output('Reporte de Ganancias','I');
?>