<?php
	$this->load->library('fpdf');
	
	$GLOBALS['dataArray'] = array(
        'Empresa' => $configs['NombreEmpresa'],
        'Direccion' => $configs['DireccionEmpresa'],
        'Logo' => base_url($configs['LogoEmpresa'])
    );
	
	class PDF extends FPDF{
    
        function Header(){
            global $dataArray;
            $this->Image($dataArray['Logo'],250,5,25);
            $this->SetFont('Arial','B',15);
            $this->SetY(6);
            $this->Cell(0,8,utf8_decode('Reporte de Lineas de Productos'),0,1,'C');
            $this->SetFont('Arial','B',12);
            $this->SetY(12);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Empresa'])),0,1,'C');
            $this->SetY(17);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Direccion'])),0,1,'C');
            $this->Ln(3);
        }
        
        function Footer(){
            $this->SetY(-15);
            $this->SetFont('Arial','I',7);
            $this->Cell(200,6,utf8_decode('Pagina '.$this->PageNo().'/{nb}'),0,0,'L');
            $this->Cell(60,6,utf8_decode(gmdate('d-m-Y H:i:s', strtotime('- 6 hours'))),0,1,'R');
            $this->Cell(60,6,utf8_decode('Miracle v1.5 - Todos los Derechos Reservados 2012 - '.date('Y').' - Xypnos Soluciones Tecnologicas'),0,1,'L');
        }
    }
	
	$pdf = new PDF();
    $pdf->AliasNbPages(); 
    $pdf->setTitle('Reporte de Lineas de Productos');
    $pdf->setAuthor('Miracle v1.5 - Xypnos');
    $pdf->AddPage('L','Letter');
    
	/*Header Tabla*/
	$pdf->SetFont('Arial','B',11);
	$pdf->Cell(170,8,'Grupo/Subgrupo/Producto',1,0,'C');
	$pdf->Cell(30,8,'Total Producto',1,0,'C');
	$pdf->Cell(30,8,'Total Grupo',1,0,'C');
	$pdf->Cell(30,8,'Total Linea',1,1,'C');
	$pdf->SetFont('Arial','',11);
	/*Cuerpo del Documento*/
	$total = 0;
	if(isset($lineas)):	
		foreach($lineas as $linea):
			$pdf->SetFont('Arial','B',11);
			$pdf->Cell(170,8,$linea["nombre"],1,0,'L');
			$pdf->Cell(30,8,'',1,0,'R');
			$pdf->Cell(30,8,'',1,0,'R');
			$pdf->Cell(30,8,number_format($linea["total"],2),1,1,'R');
			$pdf->SetFont('Arial','',11);
			$total+=$linea["total"];
			if(is_array($linea["subgrupos"])):
				foreach($linea["subgrupos"] as $subgrupo):
					$pdf->Cell(170,8,'          '.$subgrupo["nombre"],1,0,'L');
					$pdf->Cell(30,8,'',1,0,'R');
					$pdf->Cell(30,8,number_format($subgrupo["total"],2),1,0,'R');
					$pdf->Cell(30,8,'',1,1,'R');
					if($printprod=="true"):
						if(is_array($subgrupo["productos"])):
							foreach($subgrupo["productos"] as $producto):
								$pdf->Cell(170,8,'                    '.$producto["desc"],1,0,'L');
								$pdf->Cell(30,8,number_format($producto["total"],2),1,0,'R');
								$pdf->Cell(30,8,'',1,0,'R');
								$pdf->Cell(30,8,'',1,1,'R');
							endforeach;
						endif;
					endif;
				endforeach;
			endif;
		endforeach;
		$pdf->SetFont('Arial','B',11);
		$pdf->Cell(230,8,"TOTAL",1,0,'C');
		$pdf->Cell(30,8,number_format($total,2),1,1,'R');
	endif;
    
    /*Exportamos el PDF*/
    $pdf->Output('Reporte de Lineas de Productos','I');
?>