<?php
	$this->load->library('fpdf');
	
	$GLOBALS['dataArray'] = array(
        'Empresa' => $configs['NombreEmpresa'],
        'Direccion' => $configs['DireccionEmpresa'],
        'Logo' => base_url($configs['LogoEmpresa'])
    );
	
	class PDF extends FPDF{
    
        function Header(){
            global $dataArray;
            $this->Image($dataArray['Logo'],250,5,25);
            $this->SetFont('Arial','B',15);
            $this->SetY(6);
            $this->Cell(0,8,utf8_decode('Reporte de Devoluciones'),0,1,'C');
            $this->SetFont('Arial','B',12);
            $this->SetY(12);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Empresa'])),0,1,'C');
            $this->SetY(17);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Direccion'])),0,1,'C');
            $this->Ln(3);
        }
        
        function Footer(){
            $this->SetY(-15);
            $this->SetFont('Arial','I',7);
            $this->Cell(200,6,utf8_decode('Pagina '.$this->PageNo().'/{nb}'),0,0,'L');
            $this->Cell(60,6,utf8_decode(gmdate('d-m-Y H:i:s', strtotime('- 6 hours'))),0,1,'R');
            $this->Cell(60,6,utf8_decode('Miracle v1.5 - Todos los Derechos Reservados 2012 - '.date('Y').' - Xypnos Soluciones Tecnologicas'),0,1,'L');
        }
    }
	
	$pdf = new PDF();
    $pdf->AliasNbPages(); 
    $pdf->setTitle('Reporte de Devoluciones');
    $pdf->setAuthor('Miracle v1.5 - Xypnos');
    $pdf->AddPage('L','Letter');
    
	/*Header Tabla*/
	$pdf->Cell(50,8,'Fecha',1,0,'C');
	$pdf->Cell(40,8,'Forma de Pago',1,0,'C');
	$pdf->Cell(40,8,'Documento',1,0,'C');
	$pdf->Cell(40,8,'Numero',1,0,'C');
	$pdf->Cell(60,8,'Cliente',1,0,'C');
	$pdf->Cell(30,8,'Total',1,1,'C');
	$pdf->SetFont('Arial','',11);
    /*Cuerpo del Documento*/
	$totaldevoluciones = 0;
	if(isset($devoluciones)){		
		foreach($devoluciones as $dev):
			$pdf->SetFont('Arial','',11);
			$pdf->Cell(50,8,utf8_decode(ucwords($dev->fecha_devolucion)),1,0,'L');
			switch($dev->forma_devolucion){
				case "0":
						$pdf->Cell(40,8,utf8_decode(ucwords("Credito")),1,0,'L');
					break;
				case "1":
						$pdf->Cell(40,8,utf8_decode(ucwords("Contado")),1,0,'L');
					break;
				case "2":
						$pdf->Cell(40,8,utf8_decode(ucwords("Cheque")),1,0,'L');
					break;
				case "3":
						$pdf->Cell(40,8,utf8_decode(ucwords("POS")),1,0,'L');
					break;
				case "4":
						$pdf->Cell(40,8,utf8_decode(ucwords("Abono a cuenta")),1,0,'L');
					break;
				case "5":
						$pdf->Cell(40,8,utf8_decode(ucwords("Pago electronico")),1,0,'L');
					break;
			}
			
			switch($dev->doc_devolucion){
				case "0":
						$pdf->Cell(40,8,utf8_decode(ucwords("Ninguno")),1,0,'L');
					break;
				case "1":
						$pdf->Cell(40,8,utf8_decode(ucwords("Factura")),1,0,'L');
					break;
				case "2":
						$pdf->Cell(40,8,utf8_decode(ucwords("CCF")),1,0,'L');
					break;
				case "3":
						$pdf->Cell(40,8,utf8_decode(ucwords("Ticket")),1,0,'L');
					break;
				case "4":
						$pdf->Cell(40,8,utf8_decode(ucwords("Nota de remision")),1,0,'L');
					break;
				case "5":
						$pdf->Cell(40,8,utf8_decode(ucwords("Nota de envio")),1,0,'L');
					break;
				case "6":
						$pdf->Cell(40,8,utf8_decode(ucwords("Recibo")),1,0,'L');
					break;
				case "7":
						$pdf->Cell(40,8,utf8_decode(ucwords("Orden de pedido")),1,0,'L');
					break;
				default:
						$pdf->Cell(40,8,utf8_decode(ucwords("Desconocido")),1,0,'L');
					break;
			}
			$pdf->Cell(40,8,utf8_decode(ucwords($dev->num_doc_devolucion)),1,0,'L');			
			if($pdf->GetStringWidth((!isset($dev->nombre_cliente))?$dev->nombre_cliente_devolucion:$dev->nombre_cliente) > 60){
				if($pdf->GetStringWidth((!isset($dev->nombre_cliente))?$dev->nombre_cliente_devolucion:$dev->nombre_cliente) > 120){
					$fontSize = 9;
					//$pdf->SetFontSize($fontSize -= 0.5);				
					$pdf->MultiCell(60,4,utf8_decode(strtoupper(substr((!isset($dev->nombre_cliente))?$dev->nombre_cliente_devolucion:$dev->nombre_cliente,0,60)."...")),1,'L');
					$pdf->SetXY($pdf->GetX()+230,$pdf->GetY()-8);
				}else{
					$pdf->MultiCell(60,4,utf8_decode(strtoupper((!isset($dev->nombre_cliente))?$dev->nombre_cliente_devolucion:$dev->nombre_cliente)),1,'L');
					$pdf->SetXY($pdf->GetX()+230,$pdf->GetY()-8);
				}				
			}else{
			   $pdf->Cell(60,8,utf8_decode(strtoupper((!isset($dev->nombre_cliente))?$dev->nombre_cliente_devolucion:$dev->nombre_cliente)),1,0,'L');
			}
			//$pdf->SetFontSize(11);
			$pdf->Cell(30,8,"(".number_format($dev->total,2).")",1,1,'R');

			$totaldevoluciones+= $dev->total;
			if($valores == "true"){
				/*Header*/
				$pdf->SetFont('Arial','B',10);
				$pdf->Cell(50,8,utf8_decode(ucwords("")),0,0,'L');
				$pdf->Cell(30,8,utf8_decode(ucwords("SKU")),0,0,'L');
				$pdf->Cell(30,8,utf8_decode(ucwords("Cantidad")),0,0,'L');
				$pdf->Cell(30,8,utf8_decode(ucwords("Costo")),0,0,'L');
				$pdf->Cell(90,8,utf8_decode(ucwords("Producto")),0,0,'L');
				$pdf->Cell(30,8,utf8_decode(ucwords("Total")),0,1,'L');
				$pdf->SetFont('Arial','',9);
				foreach($dev->productos as $producto){
					$pdf->Cell(50,8,utf8_decode(ucwords("")),0,0,'L');
					$pdf->Cell(30,8,utf8_decode(ucwords($producto->sku_presentacion)),0,0,'L');
					$pdf->Cell(30,8,number_format($producto->cant_entrada,2),0,0,'L');
					$pdf->Cell(30,8,number_format($producto->costo_entrada,2),0,0,'L');
					if($pdf->GetStringWidth($producto->desc_presentacion) > 90){
						if($pdf->GetStringWidth($producto->desc_presentacion) > 180){
							$fontSize = 9;
							//$pdf->SetFontSize($fontSize -= 0.5);
							$pdf->MultiCell(90,4,utf8_decode(strtoupper(substr($producto->desc_presentacion,0,50)."...")),0,'L');
							$pdf->SetXY($pdf->GetX()+230,$pdf->GetY()-8);
						}else{
							$pdf->MultiCell(90,4,utf8_decode(strtoupper($producto->desc_presentacion)),0,'L');
							$pdf->SetXY($pdf->GetX()+230,$pdf->GetY()-8);
						}				
					}else{
					   $pdf->Cell(90,8,utf8_decode(strtoupper($producto->desc_presentacion)),0,0,'L');
					}
					//$pdf->SetFontSize(11);
					
					//$pdf->Cell(30,8,utf8_decode(ucwords($producto->desc_presentacion)),0,0,'L');
					$pdf->Cell(30,8,"(".number_format($producto->cant_entrada * $producto->costo_entrada,2).")",0,1,'L');
				}				
			}
		endforeach;
		$pdf->SetFont('Arial','B',12);
		$pdf->SetX($pdf->GetX()+170);
		$pdf->Cell(60,8,'Total Devoluciones',1,0,'C');
		$pdf->Cell(30,8,"(".number_format($totaldevoluciones,2).")",1,1,'R');
	}
    
    /*Exportamos el PDF*/
    $pdf->Output('Reporte de Devoluciones','I');
?>