<?php
	$this->load->library('fpdf');
	
	$GLOBALS['dataArray'] = array(
        'Empresa' => $configs['NombreEmpresa'],
        'Direccion' => $configs['DireccionEmpresa'],
        'Logo' => base_url($configs['LogoEmpresa']),
        'Proveedor' => $proveedor[0]->nombre_proveedor,
        'DireccionProveedor' => $proveedor[0]->direccion_proveedor,
    );
	
	class PDF extends FPDF{
    
        function Header(){
            global $dataArray;
            $this->Image($dataArray['Logo'],250,5,25);
            $this->SetFont('Arial','B',15);
            $this->SetY(6);
            $this->Cell(0,8,utf8_decode('Reporte de Deudas'),0,1,'C');
            $this->SetFont('Arial','B',12);
            $this->SetY(12);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Empresa'])),0,1,'C');
            $this->SetY(17);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Direccion'])),0,1,'C');
            $this->Ln(3);
			
			/*Header Documento*/             
            $this->SetFont('Arial','',12);
            $this->Cell(35,8,'Proveedor:',0,0,'L');
            $this->SetFont('Arial','B',12);
            $this->Cell(85,8,$dataArray['Proveedor'],0,0,'L');
            
            $this->SetFont('Arial','',12);
            $this->Cell(25,8,'Direccion:',0,0,'L');
            $this->SetFont('Arial','B',12);
            $this->Cell(115,8,$dataArray['DireccionProveedor'],0,1,'L');
            
            /*Header Tabla*/
            $this->Cell(50,8,'ID',1,0,'C');
            $this->Cell(75,8,'Final',1,0,'C');
            $this->Cell(45,8,'Monto',1,0,'C');
            $this->Cell(45,8,'Saldo',1,0,'C');
            $this->Cell(45,8,'Estado',1,1,'C');
            $this->SetFont('Arial','',11);
        }
        
        function Footer(){
            $this->SetY(-15);
            $this->SetFont('Arial','I',7);
            $this->Cell(200,6,utf8_decode('Pagina '.$this->PageNo().'/{nb}'),0,0,'L');
            $this->Cell(60,6,utf8_decode(gmdate('d-m-Y H:i:s', strtotime('- 6 hours'))),0,1,'R');
            $this->Cell(60,6,utf8_decode('Miracle v1.5 - Todos los Derechos Reservados 2012 - '.date('Y').' - Xypnos Soluciones Tecnologicas'),0,1,'L');
        }
    }
	
	$pdf = new PDF();
    $pdf->AliasNbPages(); 
    $pdf->setTitle('Reporte de Deudas');
    $pdf->setAuthor('Miracle v1.5 - Xypnos');
    $pdf->AddPage('L','Letter');
    
    /*Cuerpo del Documento*/
    if(isset($deudas) && count($deudas) > 0):
        foreach($deudas as $deuda):
			$pdf->Cell(50,8,utf8_decode(ucwords($deuda->id_deuda)),1,0,'L');
			if($deuda->estado_deuda == 0){
				$pdf->Cell(75,8,'',1,0,'C');
			}else{
				$dateConvertFinal = explode('-',$deuda->finalizacion_deuda);
				$pdf->Cell(75,8,utf8_decode(ucwords($dateConvertFinal[2].' de '.TraducirMes($dateConvertFinal[1]).' del '.$dateConvertFinal[0])),1,0,'L');
			}
            
            $pdf->Cell(45,8,utf8_decode(ucwords($deuda->monto_deuda)),1,0,'R');
            $pdf->Cell(45,8,utf8_decode(ucwords($deuda->saldo_deuda)),1,0,'R');
            $pdf->Cell(45,8,utf8_decode(ucwords(($deuda->estado_deuda == 0)?"Activo":"Liquidado")),1,1,'C');
        endforeach;
    endif;
    
    /*Exportamos el PDF*/
    $pdf->Output('Reporte de Deudas '.$proveedor[0]->nombre_proveedor,'I');
	
	function TraducirMes($month){
		switch($month){
			case '01':
					return $mes = 'Enero';
				break;
			case '02':
					return $mes = 'Febrero';
				break;
			case '03':
					return $mes = 'Marzo';
				break;
			case '04':
					return $mes = 'Abril';
				break;
			case '05':
					return $mes = 'Mayo';
				break;
			case '06':
					return $mes = 'Junio';
				break;
			case '07':
					return $mes = 'Julio';
				break;
			case '08':
					return $mes = 'Agosto';
				break;
			case '09':
					return $mes = 'Septiembre';
				break;
			case '10':
					return $mes = 'Octubre';
				break;
			case '11':
					return $mes = 'Noviembre';
				break;
			case '12':
					return $mes = 'Diciembre';
				break;
		}
	}
?>