<?php
	$this->load->library('fpdf');
	
	$GLOBALS['dataArray'] = array(
        'Empresa' => $configs['NombreEmpresa'],
        'Direccion' => $configs['DireccionEmpresa'],
        'Logo' => base_url($configs['LogoEmpresa'])
    );
	
	class PDF extends FPDF{
    
        function Header(){
            global $dataArray;
            $this->Image($dataArray['Logo'],185,5,25);
            $this->SetFont('Arial','B',15);
            $this->SetY(6);
            $this->Cell(0,8,utf8_decode('Reporte de Cuentas por Cobrar'),0,1,'C');
            $this->SetFont('Arial','B',12);
            $this->SetY(12);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Empresa'])),0,1,'C');
            $this->SetY(17);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Direccion'])),0,1,'C');
            $this->Ln(3);
            $this->SetFont('Arial','B',10);
			
			/*Header Tabla*/
            $this->Cell(136,8,'Cliente',1,0,'C');
            $this->Cell(20,8,'Saldo',1,0,'C');
            $this->Cell(20,8,'Monto',1,0,'C');
            $this->Cell(20,8,'Disponible',1,1,'C');
            $this->SetFont('Arial','',10);
        }
        
        function Footer(){
            $this->SetY(-15);
            $this->SetFont('Arial','I',7);
            $this->Cell(135,6,utf8_decode('Pagina '.$this->PageNo().'/{nb}'),0,0,'L');
            $this->Cell(60,6,utf8_decode(gmdate('d-m-Y H:i:s', strtotime('- 6 hours'))),0,1,'R');
            $this->Cell(60,6,utf8_decode('Miracle v1.5 - Todos los Derechos Reservados 2012 - '.date('Y').' - Xypnos Soluciones Tecnologicas'),0,1,'L');
        }
    }
	
	$pdf = new PDF();
    $pdf->AliasNbPages(); 
    $pdf->setTitle('Reporte de Cuentas por Cobrar');
    $pdf->setAuthor('Miracle v1.5 - Xypnos');
    $pdf->AddPage('P','Letter');
    
    /*Cuerpo del Documento*/
    if(isset($clientes) && count($clientes) > 0):
		$total = 0;
		$pdf->SetFillColor(255, 255, 126);
        foreach($clientes as $cliente):
			$pdf->Cell(136,8,utf8_decode(ucwords(substr($cliente->nombre,0,60))),1,0,'L');
			$pdf->Cell(20,8,(float)$cliente->saldo,1,0,'J');
			$pdf->Cell(20,8,(float)$cliente->limite,1,0,'J');
			$pdf->Cell(20,8,(float)($cliente->limite - $cliente->saldo),1,1,'J');
			$total+= $cliente->saldo;
			
        endforeach;
        $pdf->SetFont('Arial','B',12);
        $pdf->Cell(136,8,'Total Credito',1,0,'C');
        $pdf->Cell(20,8,(float)$total,1,1,'R');
    endif;
    
    /*Exportamos el PDF*/
    $pdf->Output('Reporte de Cuentas por Cobrar','I');
?>