<?php
	$this->load->library('fpdf');
	if(isset($creditos[0]->id_credito)){
		$idCredito = $creditos[0]->id_credito;
	}else{
		$idCredito = "";
	}
	$GLOBALS['dataArray'] = array(
        'Empresa' => $configs['NombreEmpresa'],
        'Direccion' => $configs['DireccionEmpresa'],
        'Logo' => base_url($configs['LogoEmpresa']),
        'Cliente' => $cliente[0]->nombre_cliente,
        'DireccionCliente' => $cliente[0]->direccion_cliente,
        'Credito' => $idCredito
    );
	
	class PDF extends FPDF{
    
        function Header(){
            global $dataArray;
            $this->Image($dataArray['Logo'],250,5,25);
            $this->SetFont('Arial','B',15);
            $this->SetY(6);
            $this->Cell(0,8,utf8_decode('Reporte de Credito'),0,1,'C');
            $this->SetFont('Arial','B',12);
            $this->SetY(12);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Empresa'])),0,1,'C');
            $this->SetY(17);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Direccion'])),0,1,'C');
            $this->Ln(3);
			
			/*Header Documento*/     
			$this->SetFont('Arial','',12);
            $this->Cell(15,8,'ID:',0,0,'L');
            $this->SetFont('Arial','B',12);
            $this->Cell(35,8,$dataArray['Credito'],0,0,'L');
			
            $this->SetFont('Arial','',12);
            $this->Cell(15,8,'Cliente:',0,0,'L');
            $this->SetFont('Arial','B',12);
            $this->Cell(85,8,$dataArray['Cliente'],0,0,'L');
            
            $this->SetFont('Arial','',12);
            $this->Cell(25,8,'Direccion:',0,0,'L');
            $this->SetFont('Arial','B',12);
            $this->Cell(85,8,$dataArray['DireccionCliente'],0,1,'L');
            
            /*Header Tabla*/
            $this->Cell(80,8,'Fecha',1,0,'C');
            $this->Cell(60,8,'Transaccion',1,0,'C');
            $this->Cell(40,8,'Cargos',1,0,'C');
            $this->Cell(40,8,'Abonos',1,0,'C');
            $this->Cell(40,8,'Saldo',1,1,'C');
            $this->SetFont('Arial','',11);
        }
        
        function Footer(){
            $this->SetY(-15);
            $this->SetFont('Arial','I',7);
            $this->Cell(200,6,utf8_decode('Pagina '.$this->PageNo().'/{nb}'),0,0,'L');
            $this->Cell(60,6,utf8_decode(gmdate('d-m-Y H:i:s', strtotime('- 6 hours'))),0,1,'R');
            $this->Cell(60,6,utf8_decode('Miracle v1.5 - Todos los Derechos Reservados 2012 - '.date('Y').' - Xypnos Soluciones Tecnologicas'),0,1,'L');
        }
    }
	
	$pdf = new PDF();
    $pdf->AliasNbPages(); 
    $pdf->setTitle('Reporte de Credito');
    $pdf->setAuthor('Miracle v1.5 - Xypnos');
    $pdf->AddPage('L','Letter');
    
    /*Cuerpo del Documento*/
    if(isset($creditos) && count($creditos) > 0):
        foreach($creditos as $credito):
			$dateConvert = explode('-',$credito->fecha_transaccion);
			$timeConvert = explode(' ',$dateConvert[2]);
            $pdf->Cell(80,8,utf8_decode(ucwords($timeConvert[0].' de '.TraducirMes($dateConvert[1]).' del '.$dateConvert[0].' a las '.$timeConvert[1])),1,0,'L');
			$pdf->Cell(60,8,utf8_decode(ucwords($credito->ref_transaccion)),1,0,'L');
			if($credito->tipo_transaccion == 0){
				$pdf->Cell(40,8,utf8_decode(ucwords($credito->monto_transaccion)),1,0,'R');
				$pdf->Cell(40,8,utf8_decode(ucwords('')),1,0,'R');
			}else{
				$pdf->Cell(40,8,utf8_decode(ucwords('')),1,0,'R');
				$pdf->Cell(40,8,utf8_decode(ucwords($credito->monto_transaccion)),1,0,'R');
			}
			
            $pdf->Cell(40,8,utf8_decode(ucwords($credito->saldo_transaccion)),1,1,'R');
        endforeach;
    endif;
    
    /*Exportamos el PDF*/
    $pdf->Output('Reporte de Credito '.$idCredito.' - '.$cliente[0]->nombre_cliente,'I');
	
	function TraducirMes($month){
		switch($month){
			case '01':
					return $mes = 'Enero';
				break;
			case '02':
					return $mes = 'Febrero';
				break;
			case '03':
					return $mes = 'Marzo';
				break;
			case '04':
					return $mes = 'Abril';
				break;
			case '05':
					return $mes = 'Mayo';
				break;
			case '06':
					return $mes = 'Junio';
				break;
			case '07':
					return $mes = 'Julio';
				break;
			case '08':
					return $mes = 'Agosto';
				break;
			case '09':
					return $mes = 'Septiembre';
				break;
			case '10':
					return $mes = 'Octubre';
				break;
			case '11':
					return $mes = 'Noviembre';
				break;
			case '12':
					return $mes = 'Diciembre';
				break;
		}
	}
?>