<?php
	$this->load->library('fpdf');
	
	$GLOBALS['dataArray'] = array(
        'Empresa' => $configs['NombreEmpresa'],
        'Direccion' => $configs['DireccionEmpresa'],
        'Logo' => base_url($configs['LogoEmpresa'])
    );
	
	class PDF extends FPDF{
    
        function Header(){
            global $dataArray;
            $this->Image($dataArray['Logo'],250,5,25);
            $this->SetFont('Arial','B',15);
            $this->SetY(6);
            $this->Cell(0,8,utf8_decode('Reporte de Compras'),0,1,'C');
            $this->SetFont('Arial','B',12);
            $this->SetY(12);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Empresa'])),0,1,'C');
            $this->SetY(17);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Direccion'])),0,1,'C');
            $this->Ln(3);
            
            /*Header Tabla*/
            $this->SetFont('Arial','B',10);
            $this->Cell(25,8,'Ref',1,0,'C');
            $this->Cell(30,8,'Fecha',1,0,'C');
            $this->Cell(60,8,'Proveedor',1,0,'C');
            $this->Cell(40,8,'Documento',1,0,'C');
            $this->Cell(30,8,'Forma de Pago',1,0,'C');
            $this->Cell(45,8,'Usuario',1,0,'C');
            $this->Cell(30,8,'Total',1,1,'C');
            $this->SetFont('Arial','',8);
        }
        
        function Footer(){
            $this->SetY(-15);
            $this->SetFont('Arial','I',7);
            $this->Cell(200,6,utf8_decode('Pagina '.$this->PageNo().'/{nb}'),0,0,'L');
            $this->Cell(60,6,utf8_decode(gmdate('d-m-Y H:i:s', strtotime('- 6 hours'))),0,1,'R');
            $this->Cell(60,6,utf8_decode('Miracle v1.5 - Todos los Derechos Reservados 2012 - '.date('Y').' - Xypnos Soluciones Tecnologicas'),0,1,'L');
        }
    }
	
	$pdf = new PDF();
    $pdf->AliasNbPages(); 
    $pdf->setTitle('Reporte de Compras');
    $pdf->setAuthor('Miracle v1.5 - Xypnos');
    $pdf->AddPage('L','Letter');
    
    /*Cuerpo del Documento*/
	if(isset($compras) && count($compras) > 0):
		$total = 0;
		$pdf->SetFillColor(255, 255, 126);
        foreach($compras as $compra):
            $pdf->Cell(25,8,utf8_decode(ucwords("C-".$compra->id_compra)),1,0,'L');
            $pdf->Cell(30,8,utf8_decode(ucwords($compra->fecha_compra)),1,0,'L');
            $pdf->Cell(60,8,utf8_decode(ucwords($compra->nombre_proveedor)),1,0,'L');
			
			switch($compra->documento_compra){
				case "0":
						$pdf->Cell(40,8,utf8_decode(ucwords("CCF ".$compra->num_doc_compra)),1,0,'L');
					break;
				case "1":
						$pdf->Cell(40,8,utf8_decode(ucwords("Factura ".$compra->num_doc_compra)),1,0,'L');
					break;
				case "2":
						$pdf->Cell(40,8,utf8_decode(ucwords("Nota de Envio ".$compra->num_doc_compra)),1,0,'L');
					break;
			}
			
			if($compra->forma_pago_compra == 0){
				$pdf->Cell(30,8,utf8_decode(ucwords("Contado")),1,0,'L');
			}else{
				$pdf->Cell(30,8,utf8_decode(ucwords("Credito")),1,0,'L');
			}
			$pdf->Cell(45,8,utf8_decode(ucwords($compra->nombre_usuario)),1,0,'L');
			$pdf->Cell(30,8,utf8_decode(ucwords($compra->total)),1,1,'R');
			$total+= $compra->total;
			
			if($includeProducts){
				/*Header*/
				$pdf->SetFont('Arial','B',9);
				$pdf->Cell(50,8,utf8_decode(ucwords("")),0,0,'L');
				$pdf->Cell(30,8,utf8_decode(ucwords("SKU")),0,0,'L');
				$pdf->Cell(30,8,utf8_decode(ucwords("Cantidad")),0,0,'L');
				$pdf->Cell(30,8,utf8_decode(ucwords("Costo")),0,0,'L');
				$pdf->Cell(90,8,utf8_decode(ucwords("Producto")),0,0,'L');
				$pdf->Cell(30,8,utf8_decode(ucwords("Total")),0,1,'L');
				$pdf->SetFont('Arial','',8);
				foreach($compra->productos as $producto){
					$pdf->Cell(50,8,utf8_decode(ucwords("")),0,0,'L');
					$pdf->Cell(30,8,utf8_decode(ucwords($producto->sku_presentacion)),0,0,'L');
					$pdf->Cell(30,8,number_format($producto->cant_entrada,2),0,0,'L');
					$pdf->Cell(30,8,number_format($producto->costo_entrada,2),0,0,'L');
					if($pdf->GetStringWidth($producto->desc_presentacion) > 90){
						if($pdf->GetStringWidth($producto->desc_presentacion) > 180){
							$fontSize = 8;
							//$pdf->SetFontSize($fontSize -= 0.5);
							$pdf->MultiCell(90,4,utf8_decode(strtoupper(substr($producto->desc_presentacion,0,50)."...")),0,'L');
							$pdf->SetXY($pdf->GetX()+230,$pdf->GetY()-8);
						}else{
							$pdf->MultiCell(90,4,utf8_decode(strtoupper($producto->desc_presentacion)),0,'L');
							$pdf->SetXY($pdf->GetX()+230,$pdf->GetY()-8);
						}				
					}else{
					   $pdf->Cell(90,8,utf8_decode(strtoupper($producto->desc_presentacion)),0,0,'L');
					}
					//$pdf->SetFontSize(11);
					
					//$pdf->Cell(30,8,utf8_decode(ucwords($producto->desc_presentacion)),0,0,'L');
					$pdf->Cell(30,8,number_format($producto->cant_entrada * $producto->costo_entrada,2),0,1,'L');
				}				
			}
			
        endforeach;
        $pdf->SetFont('Arial','B',12);
        $pdf->Cell(230,8,'Total Compras',1,0,'R');
        $pdf->Cell(30,8,(float)$total,1,1,'R');
    endif;
    
    /*Exportamos el PDF*/
    $pdf->Output('Reporte de Compras','I');
?>