<?php
	$this->load->library('fpdf');
	
	$GLOBALS['dataArray'] = array(
        'Empresa' => $configs['NombreEmpresa'],
        'Direccion' => $configs['DireccionEmpresa'],
        'Logo' => base_url($configs['LogoEmpresa']),
        'Vendedor' => $vendedor[0]->nombre,
        'TotalVenta' => $totalventa,
        'TotalComision' => $totalcomi,
        'FechaDesde' => $fechadesde,
        'FechaHasta' => $fechahasta,
        'Meta' => $meta
    );
	
	class PDF extends FPDF{
    
        function Header(){
            global $dataArray;
			
			$fechadesde = new DateTime($dataArray['FechaDesde']);
			$fechahasta = new DateTime($dataArray['FechaHasta']);
			
            $this->Image($dataArray['Logo'],250,5,25);
            $this->SetFont('Arial','B',15);
            $this->SetY(6);
            $this->Cell(0,8,utf8_decode('Reporte de Comisiones'),0,1,'C');
            $this->SetFont('Arial','B',11);
            $this->SetY(12);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Empresa'])),0,1,'C');
            $this->SetY(17);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Direccion'])),0,1,'C');
            $this->Ln(3);
			
			$this->SetFont('Arial','',11);
            $this->Cell(20,8,'Vendedor',0,0,'L');
			$this->SetFont('Arial','B',11);
            $this->Cell(60,8,utf8_decode($dataArray['Vendedor']),0,0,'L');
			
			$this->SetFont('Arial','',11);
            $this->Cell(30,8,'Venta Contado',0,0,'L');
			$this->SetFont('Arial','B',11);
            $this->Cell(30,8,$dataArray['TotalVenta'],0,0,'L');
			
			$this->SetFont('Arial','',11);
            $this->Cell(20,8,'Comision',0,0,'L');
			$this->SetFont('Arial','B',11);
            $this->Cell(30,8,$dataArray['TotalComision'],0,0,'L');
			
			$this->SetFont('Arial','',11);
            $this->Cell(20,8,'Periodo',0,0,'L');
			$this->SetFont('Arial','B',11);
            $this->Cell(50,8,$fechadesde->format('d-m-Y').' - '.$fechahasta->format('d-m-Y'),0,1,'L');
			
			$this->SetFont('Arial','',11);
            $this->Cell(20,8,'Meta',0,0,'L');
			$this->SetFont('Arial','B',11);
            $this->Cell(60,8,$dataArray['Meta'],0,0,'L');
			
			if($dataArray['Meta'] > 0){
				$this->SetFont('Arial','',11);
				$this->Cell(30,8,'Restante',0,0,'L');
				$this->SetFont('Arial','B',11);
				$this->Cell(30,8,$dataArray['Meta'] - $dataArray['TotalVenta'],0,1,'L');
			}else{
				$this->SetFont('Arial','',11);
				$this->Cell(30,8,'Restante',0,0,'L');
				$this->SetFont('Arial','B',11);
				$this->Cell(30,8,"No aplica",0,1,'L');
			}
			$this->Ln(3);
			
            /*Header Tabla*/
            $this->Cell(80,8,'Decripcion',1,0,'C');
            $this->Cell(30,8,'Cantidad',1,0,'C');
            $this->Cell(30,8,'Precio Venta',1,0,'C');
            $this->Cell(30,8,'Total',1,0,'C');
            $this->Cell(30,8,'Pre. aplicable',1,0,'C');
            $this->Cell(30,8,'Com. aplicable',1,0,'C');
            $this->Cell(30,8,'Comision',1,1,'C');
            $this->SetFont('Arial','',11);
        }
        
        function Footer(){
            $this->SetY(-15);
            $this->SetFont('Arial','I',7);
            $this->Cell(200,6,utf8_decode('Pagina '.$this->PageNo().'/{nb}'),0,0,'L');
            $this->Cell(60,6,utf8_decode(gmdate('d-m-Y H:i:s', strtotime('- 6 hours'))),0,1,'R');
            $this->Cell(60,6,utf8_decode('Miracle v1.5 - Todos los Derechos Reservados 2012 - '.date('Y').' - Xypnos Soluciones Tecnologicas'),0,1,'L');
        }
    }
	
	$pdf = new PDF();
    $pdf->AliasNbPages(); 
    $pdf->setTitle('Reporte de Comisiones');
    $pdf->setAuthor('Miracle v1.5 - Xypnos');
    $pdf->AddPage('L','Letter');
    
    /*Cuerpo del Documento*/
    if(isset($productos) && count($productos) > 0):
		foreach($productos as $i=>$producto){
			//$pdf->Cell(80,8,substr($producto->desc,0,32),1,0,'L');
			if($pdf->GetStringWidth($producto->desc) > 80){
				if($pdf->GetStringWidth($producto->desc) > 160){
					$fontSize = 9;
					//$pdf->SetFontSize($fontSize -= 0.5);
					$pdf->MultiCell(80,4,utf8_decode(strtoupper(substr($producto->desc,0,50)."...")),1,'L');
					$pdf->SetXY($pdf->GetX()+80,$pdf->GetY()-8);
				}else{
					$pdf->MultiCell(80,4,utf8_decode(strtoupper($producto->desc)),1,'L');
					$pdf->SetXY($pdf->GetX()+80,$pdf->GetY()-8);
				}				
			}else{
			   $pdf->Cell(80,8,utf8_decode(strtoupper($producto->desc)),1,0,'L');
			}
			$pdf->Cell(30,8,number_format($producto->cantidad,2),1,0,'L');
			$pdf->Cell(30,8,number_format($producto->preciov,2),1,0,'L');
			$pdf->Cell(30,8,number_format($producto->total,2),1,0,'L');
			$pdf->Cell(30,8,$producto->aplicable,1,0,'L');
			$pdf->Cell(30,8,number_format($producto->comisionapli,2),1,0,'L');
			$pdf->Cell(30,8,number_format($producto->comision,2),1,1,'L');
		}
    endif;
    
    /*Exportamos el PDF*/
    $pdf->Output('Reporte de Comisiones','I');
?>