<div id="grafico-lineas-container"></div>
<script>
$(function () {
	<?php
		if(isset($lineas)):
			$totalventas = 0;
			foreach($lineas as $linea):
				if(is_array($linea->productos_ventas)){
					foreach($linea->productos_ventas as $ventas){
						$totalventas+=$ventas->ventas;
					}
				}else{
					$totalventas+= 0;
				}
			endforeach;
	?>	
    $('#grafico-lineas-container').highcharts({
		title: {
            text: 'Grafico de Ventas por Linea de Productos',
            x: -20
        },
        subtitle: {
            text: 'Fuente: Base de Datos Miracle v1.5.0',
            x: -20
        },
         chart: {
            plotBackgroundColor: null,
            plotBorderWidth: null,
            plotShadow: false,
            type: 'pie'
        },
        tooltip: {
            pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
        },
        plotOptions: {
            pie: {
                allowPointSelect: true,
                cursor: 'pointer',
                dataLabels: {
                    enabled: <?php echo $valores;?>,
                    format: '<b>{point.name}</b>: {point.percentage:.1f} %',
                    style: {
                        color: (Highcharts.theme && Highcharts.theme.contrastTextColor) || 'black'
                    }
                }
            }
        },
        series: [{
            name: "Ventas",
            colorByPoint: true,
            data: [
					<?php
						$ventas_linea = 0;
						$primerlineaID = $lineas[0]->id_grupo;
						$primerlineaNOMBRE = $lineas[0]->nombre_grupo;
						foreach($lineas as $linea):
							if($primerlineaID == $linea->id_grupo){
								if(is_array($linea->productos_ventas)){
									foreach($linea->productos_ventas as $ventas){
										$ventas_linea+=$ventas->ventas;
									}
								}else{
									$ventas_linea+= 0;
								}
							}else{
								if($ventas_linea > 0){
									echo '{name: "'.$primerlineaNOMBRE.'",';
									echo 'y:'.($ventas_linea * 100)/$totalventas.',drilldown: "'.$primerlineaNOMBRE.'"},';
								}								
								
								$primerlineaID = $linea->id_grupo;
								$primerlineaNOMBRE = $linea->nombre_grupo;
								$ventas_linea = 0;
								
								if(is_array($linea->productos_ventas)){
									foreach($linea->productos_ventas as $ventas){
										$ventas_linea+=$ventas->ventas;
									}
								}else{
									$ventas_linea+= 0;
								}
							}
						endforeach;
						if($ventas_linea > 0){
							echo '{name: "'.$primerlineaNOMBRE.'",';
							echo 'y:'.($ventas_linea * 100)/$totalventas.',drilldown: "'.$primerlineaNOMBRE.'"},';
						}
					?>
			]
        }],
		drilldown: {
            series: [
				<?php
					foreach($lineas as $linea):
						echo '{name: "'.$linea->nombre_grupo.'",';
						echo 'id: "'.$linea->nombre_grupo.'",data:[';
							if(is_array($linea->productos_ventas)){
								$contador = 0;
								$ventas_producto = 0;
								$arrayLinea = json_decode(json_encode($linea->productos_ventas),true);
								usort($arrayLinea, "cmp");
								foreach($arrayLinea as $ventas){
									if($contador < 5 && $ventas["ventas"] > 0){
										echo '["'.$ventas["desc_producto"].'",'.$ventas["ventas"].'],';										
									}else{
										$ventas_producto+= $ventas["ventas"];
									}
									$contador++;
								}
								if($ventas_producto > 0){
									echo '["Resto de Productos",'.$ventas_producto.'],';	
								}											
							}
						echo "]},";
					endforeach;
				?>
			]
        }
    });
	<?php
		else:
	?>
	toastr.options = {
	  "closeButton": true,
	  "progressBar": true,
	  "positionClass": "toast-top-right"
	}
	toastr.error('No hay informacion obtenida para dibujar un grafico');
	<?php
		endif;
	?>
});
</script>
<?php
	function cmp($a, $b){
		return $b['ventas'] - $a['ventas'];
	}
?>