<div class="panel blank-panel">
	<div class="panel-heading">
		<div class="panel-options">
			<ul class="nav nav-tabs">
				<li class="active"><a data-toggle="tab" href="#ventas">Ventas</a></li>
				<li><a data-toggle="tab" href="#otras">Otras Salidas</a></li>				
			</ul>
		</div>
		<div class="panel-body">
			<div class="tab-content">
				<div id="ventas" class="tab-pane active">
					<table id="salidas-ventas-tabla" class="table table-striped">
						<thead>
							<tr>
								<th>Referencia</th>
								<th>Fecha</th>
								<th>Vendedor</th>
								<th>Cliente</th>
								<th>Documento</th>
								<th>Numero</th>
								<th>Total</th>
								<th>Estado</th>
								<th>Acciones</th>
							</tr>
						</thead>
						<tbody></tbody>
					</table>
				</div>	
				<div id="otras" class="tab-pane">
					<table id="salidas-otras-tabla" class="table">
						<thead>
							<tr>
								<th>Fecha</th>
								<th>Transacci&oacute;n</th>
								<th>Acciones</th>
							</tr>
						</thead>
						<tbody>
							
						</tbody>
					</table>
				</div>	
			 </div>
		</div>
	</div>
</div>
<script>	
	$(document).ready(function(){
		var tableVentas=$("#salidas-ventas-tabla").DataTable({
			serverSide: true,
			ajax:{
				url:'<?php echo base_url()?>productos/cargar_ventas',
				data:function(d){
					d.search['by']=$('#ventas-param-select-search').val();
					d.search['doc']=$('#ventas-doc-select-search').val();
				}
			},
			dom: 'l<"custom_searchbox_ventas">tip',
			order: [ 0, 'desc' ],
			columns:[
				{name:'referencia',data:0},
				{name:'fecha',data:1},
				{name:'vendedor',data:2},
				{name:'cliente',data:3},
				{name:'documento',data:4},
				{name:'numero',data:5},
				{name:'total',data:6,orderable:false},
				{name:'estado',data:7},
				{name:'acciones',data:8,orderable:false},
			],
			language: {
				"emptyTable":"",
				"lengthMenu": "Mostrar _MENU_ registros por pagina",
				"zeroRecords":"",
				"info": "Pagina _PAGE_ de _PAGES_ de _MAX_ registros encontrados",
				"infoEmpty":"No hay registros",
				"infoFiltered":"(Ningun resultado encontrado de _MAX_ registros)",
				"search":"Buscar:",
				"paginate": {
					"first":"Primero",
					"last": "Ultimo",
					"next": "Siguiente",
					"previous":"Anterior"
				}
			},
		});
		$("div.custom_searchbox_ventas").html("<div class='pull-right m-sm'><label>Buscar:</label> <select class='form-control' id='ventas-param-select-search'><option value='referencia' selected>Referencia</option><option value='fecha'>Fecha</option><option value='vendedor'>Vendedor</option><option value='cliente'>Cliente</option><option value='documento'>Documento</option></select><div id='ventas-field-search-wrapper' class='pull-right'><input type='text' id='ventas-table-search-field' class='form-control' style='width:250px;' placeholder='Numero de referencia'></div></div><div class='clear-fix'></div>")
		$("#ventas-param-select-search").on("change",function(){
			$fieldWrapper=$("#ventas-field-search-wrapper");
			$fieldWrapper.html("");
			var $textbox=$("<input type='text' id='ventas-textbox-search' class='form-control' style='width:250px;'>");
			var $select=$("<select id='ventas-select-search' class='form-control' style='width:250px;'></select>");
			switch($(this).val()){
				case "referencia":
					$textbox.attr("placeholder","Numero de referencia");
					$fieldWrapper.append($textbox);
					$textbox.on("keyup",function(){
						tableVentas.search($(this).val()).draw();
					});
					$textbox.focus();
				break;
				case "fecha":
					$textbox.attr("placeholder","Seleccione una fecha");
					$textbox.attr("readonly","readonly");
					$fieldWrapper.append($textbox);
					$textbox.daterangepicker({
						format: 'DD-MM-YYYY',
						separator: ' al ',
						singleDatePicker: true,
						locale:{
							applyLabel: 'Aplicar',
							cancelLabel: 'Cancelar',
							fromLabel: 'Desde',
							toLabel: 'Hasta',
							weekLabel: 'W',
							customRangeLabel: 'Custom Range',
							daysOfWeek: ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi','Sa'],
							monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre']
						},
						showDropdowns: true
					});
					$textbox.on("change",function(){
						tableVentas.search($(this).val()).draw();
					});
					$textbox.focus();
				break;
				case "vendedor":
					$select.html("<option disabled selected>Seleccione uno...</option>"
					<?php if(count($vendedores)):foreach($vendedores as $vendedor):?>
					+"<option value='<?php echo $vendedor->id_usuario;?>'><?php echo $vendedor->nombre_usuario;?></option>"
					<?php endforeach;endif;?>
					);
					$fieldWrapper.append($select);
					$select.on("change",function(){
						tableVentas.search($(this).val()).draw();
					});
					$select.focus();
					break;
				case "cliente":
					$textbox.attr("placeholder","Nombre del cliente");
					$fieldWrapper.append($textbox);
					$textbox.on("keyup",function(){
						tableVentas.search($(this).val()).draw();
					});
					$textbox.focus();
					break;
				case "documento":
					$select.html("<option value='' selected>Todos</option><option value='1'>Factura</option><option value='2'>CCF</option><option value='3'>Ticket</option><option value='4'>N. Remisi&oacute;n</option><option value='5'>N. Env&iacute;o</option>")
					$select.attr("style","width:125px;");
					$select.attr("id","ventas-doc-select-search");
					$textbox.attr("style","width:125px;");
					$fieldWrapper.append($select);
					$fieldWrapper.append($textbox);
					$select.on("change",function(){
						tableVentas.search('').draw();
						$textbox.val('');
						$textbox.focus();
					});
					$textbox.on("keyup",function(){
						tableVentas.search($(this).val()).draw();
					});
					$select.focus();
					break;
			}
			tableVentas.search('').draw();
		});
		$("#ventas-table-search-field").on("keyup",function(){
			tableVentas.search($(this).val()).draw();
		});
		$("#salidas-ventas-tabla").on("click",".ventas-table-view-btn",function(e){
				e.preventDefault();
				var id= $(this).attr("data-id");
				Custombox.open({
					target: '<?php echo base_url();?>productos/salidadetalles?transaccion='+id+'&source=venta',
					effect: 'fadein'
				});
		});
		/*Otras salidas*/
		var tableOtrasSalidas=$("#salidas-otras-tabla").DataTable({
				serverSide: true,
				ajax:{
					url:'<?php echo base_url()?>productos/cargar_salidas',
				},
				order: [ 0, 'desc' ],
				columns:[
					{name:'fecha',data:0},
					{name:'transaccion',data:1,orderable:false},
					{name:'acciones',data:2,orderable:false,width:"15%"},
				],
				language: {
					"emptyTable":"",
					"lengthMenu": "Mostrar _MENU_ registros por pagina",
					"zeroRecords":"",
					"info": "Pagina _PAGE_ de _PAGES_ de _MAX_ registros encontrados",
					"infoEmpty":"No hay registros",
					"infoFiltered":"(Ningun resultado encontrado de _MAX_ registros)",
					"search":"Buscar:",
					"paginate": {
						"first":"Primero",
						"last": "Ultimo",
						"next": "Siguiente",
						"previous":"Anterior"
					}
				},
			});
		$("#salidas-otras-tabla").on("click",".salidas-table-view-btn",function(e){
				e.preventDefault();
				var id= $(this).attr("data-id");
				Custombox.open({
					target: '<?php echo base_url();?>productos/salidadetalles?transaccion='+id,
					effect: 'fadein'
				});
		});

});
	
	
	/* $(document).ready(function() {
		var userString = "<?php if(isset($vendedores)):foreach($vendedores as $vendedor):?><option value='<?php echo $vendedor->id_usuario;?>'><?php echo $vendedor->nombre_usuario;?></option><?php endforeach;endif;?>";
		
		var tableData = $("#tableVentas").DataTable({
			serverSide: true,
			order: [ 2, 'desc' ],
			dom: '<"filtercustom_boxVentas">lftip',
			ajax: {
				"url": "<?php echo base_url()?>productos/cargar_ventas",
				"data": function ( d ) {
					d.search_select = $('#filtercustom_selectventas').val();
					d.search_text = $('#filtercustom_textventas').val();
					d.search_select_custom = $('#filtercustom_select_customventas').val();
				}
			},
			columns:[
				{name:'id',data:0},
				{name:'referencia',data:1},
				{name:'fecha',data:2},
				{name:'cajero',data:3},
				{name:'vendedor',data:4},
				{name:'documento',data:5},
				{name:'numero',data:6},
				{name:'total',data:7},
				{
					orderable:false,
					data:null,
					defaultContent:'<button class="btn btn-info btn-xs view-item">Ver salida</button>'
				}
			],
			columnDefs: [
				{
					targets: [ 0 ],
					searchable: false,
					className:'idTableHidden'
				}
			],
			language: {
				"emptyTable":     "",
				"lengthMenu": "Mostrar _MENU_ registros por pagina",
				"zeroRecords": "",
				"info": "Pagina _PAGE_ de _PAGES_",
				"infoEmpty": "No hay registros",
				"infoFiltered": "(Ningun resultado encontrado de _MAX_ registros)",
				"search":         "Buscar:",
				"paginate": {
					"first":      "Primero",
					"last":       "Ultimo",
					"next":       "Siguiente",
					"previous":   "Anterior"
				}
			},
		});
		
		$('#tableVentas').on('click','.view-item', function ( e ) {
			var dataClick = $(this);
			Custombox.open({
				target: '<?php echo base_url();?>productos/salidadetalles?transaccion='+dataClick.closest('tr').find("td.idTableHidden").text(),
				effect: 'fadein',
				complete: function(){
					
				},
				close: function(){
					
				}
			});
			e.preventDefault();
		});
		
		$("div.filtercustom_boxVentas").html("<input id='filtercustom_textventas' type='text' class='form-control' style='margin-left:10px;height:30px;font-size:12px;width:200px;float:right;' placeholder='Buscar'/><select id='filtercustom_select_customventas' class='form-control' style='margin-left:10px;display:none;height:30px;font-size:12px;width:200px;float:right;'></select><select id='filtercustom_selectventas' class='form-control' style='height:30px;font-size:12px;width:200px;float:right;'><option value='0'>Fecha</option><option value='1'>Cajero</option><option value='2'>Vendedor</option><option value='3'>Documento</option></select>");
		
		$('#filtercustom_selectventas').on('change',function(){
			switch($('#filtercustom_selectventas').val()){
				case "0":
					$("#filtercustom_select_customventas").css('display','none');	
					getCalendarVentas();
				break;
				case "1":
					$("#filtercustom_textventas").css('display','none');
					$('#filtercustom_select_customventas').find('option').remove().end().css('display','inline-block').append(userString).focus();
				break;
				case "2":
					$("#filtercustom_textventas").css('display','none');
					$('#filtercustom_select_customventas').find('option').remove().end().css('display','inline-block').append(userString).focus();
				break;
				case "3":
					$("#filtercustom_textventas").css('display','none');
					$('#filtercustom_select_customventas').find('option').remove().end().css('display','inline-block').append('<option value="0">CCF</option><option value="1">Factura</option><option value="2">Nota de Envio</option>').focus();
					if ( $('#filtercustom_textventas').is('[readonly]') ){
						$("#filtercustom_textventas").data('daterangepicker').remove();
					}
					$("#filtercustom_textventas").css('display','inline-block').prop('readonly','').val('');
				break;
			}
			tableData.search($('div.dataTables_filter input').val()).draw();
		});
		
		$('#filtercustom_select_customventas').on('change',function(){
			switch($('#filtercustom_selectventas').val()){
				case "2":
					tableData.search($('div.dataTables_filter input').val()).draw();
				break;
				case "3":
					tableData.search($('div.dataTables_filter input').val()).draw();
					$("#filtercustom_textventas").css('display','inline-block').prop('readonly','').val('').focus();
				break;
			}
		});
		
		$('#filtercustom_textventas').on('keyup change',function(){
			tableData.search($('div.dataTables_filter input').val()).draw();
		});
		
		$('#filtercustom_textventas').daterangepicker({
			format: 'YYYY-MM-DD',
			separator: ' al ',
			singleDatePicker: true,
			locale: {
				applyLabel: 'Aplicar',
				cancelLabel: 'Cancelar',
				fromLabel: 'Desde',
				toLabel: 'Hasta',
				weekLabel: 'W',
				customRangeLabel: 'Custom Range',
				daysOfWeek: ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi','Sa'],
				monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre']
			},
			showDropdowns: true
		}).prop('readonly','readonly');
		
		function getCalendarVentas(){
			$('#filtercustom_textventas').daterangepicker({
				format: 'YYYY-MM-DD',
				separator: ' al ',
				singleDatePicker: true,
				locale: {
					applyLabel: 'Aplicar',
					cancelLabel: 'Cancelar',
					fromLabel: 'Desde',
					toLabel: 'Hasta',
					weekLabel: 'W',
					customRangeLabel: 'Custom Range',
					daysOfWeek: ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi','Sa'],
					monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre']
				},
				showDropdowns: true
			}).prop('readonly','readonly').css('display','inline-block').focus().val('');
		}
		
		var tableData = $("#tableOtras").DataTable({
			serverSide: true,
			order: [ 2, 'desc' ],
			ajax: {
				"url": "<?php echo base_url()?>productos/cargar_salidas",
				"data": function ( d ) {
					
				}
			},
			columns:[
				{name:'id',data:0},
				{name:'referencia',data:1},
				{name:'fecha',data:2},
				{name:'concepto',data:3},
				{
					orderable:false,
					data:null,
					defaultContent:'<button class="btn btn-info btn-xs view-item">Ver salida</button>'
				}
			],
			columnDefs: [
				{
					targets: [ 0 ],
					searchable: false,
					className:'idTableHidden'
				}
			],
			language: {
				"emptyTable":     "",
				"lengthMenu": "Mostrar _MENU_ registros por pagina",
				"zeroRecords": "",
				"info": "Pagina _PAGE_ de _PAGES_",
				"infoEmpty": "No hay registros",
				"infoFiltered": "(Ningun resultado encontrado de _MAX_ registros)",
				"search":         "Buscar:",
				"paginate": {
					"first":      "Primero",
					"last":       "Ultimo",
					"next":       "Siguiente",
					"previous":   "Anterior"
				}
			},
		});
		
		$('#tableOtras').on('click','.view-item', function ( e ) {
			var dataClick = $(this);
			Custombox.open({
				target: '<?php echo base_url();?>productos/salidadetalles?transaccion='+dataClick.closest('tr').find("td.idTableHidden").text(),
				effect: 'fadein',
				complete: function(){
					
				},
				close: function(){
					
				}
			});
			e.preventDefault();
		});
	}); */
</script>