<?php
	$this->load->library('printer');
	$this->load->library('enletras');
	$this->load->library('App_utilities');
	$MiracleApp = new App_utilities();
	
	$phpPrinter = new Printer();
	$phpInletters = new EnLetras();
	
	$acum = 0;
	
	/*Init*/
	$printer = printer_open("EPSON TM-U950 Slip");

	printer_set_option($printer, PRINTER_MODE, 'RAW');

	printer_start_doc($printer, 'Orden de Pedido: '.$pedido->id_pedido);

	printer_start_page($printer);
	
	/*Body*/
	
	$font = printer_create_font('Arial', 9, 7, PRINTER_FW_THIN, false, false, false, 0);	
	printer_select_font($printer, $font);
	
	/*Ghost*/
	$phpPrinter->printString(strtoupper(utf8_decode(substr(" ",0,24))),2,$printer,$acum,13,11,70);
	$phpPrinter->tabPrinter($acum,50);
	
	$phpPrinter->printString(strtoupper(utf8_decode("ORDEN DE PEDIDO ".$pedido->id_pedido)),2,$printer,$acum,13,11,50);
	$phpPrinter->tabPrinter($acum,5);
	$phpPrinter->printString(strtoupper(utf8_decode($nombre_empresa)),2,$printer,$acum,13,11,50);
	$phpPrinter->tabPrinter($acum,5);
	$phpPrinter->printString(utf8_decode("Fecha"),2,$printer,$acum,13,11,50);
	$phpPrinter->printString(utf8_decode($MiracleApp->fechaHoraElSalvador($pedido->fecha_pedido,0)),2,$printer,$acum,13,0,300);
	$phpPrinter->tabPrinter($acum,5);
	$phpPrinter->printString(utf8_decode("Cliente"),2,$printer,$acum,13,11,50);
	$phpPrinter->printString(utf8_decode($pedido->nombre_cliente),2,$printer,$acum,13,0,300);
	$phpPrinter->tabPrinter($acum,5);
	$phpPrinter->printString(utf8_decode("Cajero"),2,$printer,$acum,13,11,50);
	$phpPrinter->printString(utf8_decode($pedido->nombre_usuario),2,$printer,$acum,13,0,300);
	$phpPrinter->tabPrinter($acum,5);
	$phpPrinter->printString(utf8_decode("Caja"),2,$printer,$acum,13,11,50);
	$phpPrinter->printString(utf8_decode($pedido->nombre_caja),2,$printer,$acum,13,0,300);
	$phpPrinter->tabPrinter($acum,5);
	$phpPrinter->printString(utf8_decode("Entrega"),2,$printer,$acum,13,11,50);
	$phpPrinter->printString(utf8_decode($MiracleApp->fechaHoraElSalvador($pedido->fecha_entrega_pedido,1)),2,$printer,$acum,13,0,300);
	$phpPrinter->tabPrinter($acum,5);
	
	$phpPrinter->printString(strtoupper(utf8_decode('Cant')),2,$printer,$acum,13,11,50);
	$phpPrinter->printString(strtoupper(utf8_decode('Desc')),2,$printer,$acum,13,0,300);
	$phpPrinter->printString(strtoupper(utf8_decode('P/U')),2,$printer,$acum,13,0,530);
	$phpPrinter->printString(strtoupper(utf8_decode('Total')),2,$printer,$acum,13,0,690);
	$phpPrinter->printString(utf8_decode("________________________________________________________________"),2,$printer,$acum,13,11,50);
	$phpPrinter->tabPrinter($acum,15);
	
	/*Productos*/
	foreach($productos as $producto){
		$phpPrinter->printString(number_format($producto->cantidad_producto,2),2,$printer,$acum,13,11,50);
		$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode(addslashes($producto->desc_presentacion))),30),2,$printer,$acum,13,0,130);
		$phpPrinter->printString(number_format($producto->precio_producto,2),2,$printer,$acum,13,0,550);
		$phpPrinter->printString(number_format($producto->cantidad_producto * $producto->precio_producto,2),2,$printer,$acum,13,0,710);
		$phpPrinter->tabPrinter($acum,3);
	}	
	$phpPrinter->printString(utf8_decode("________________________________________________________________"),2,$printer,$acum,13,11,50);
	$phpPrinter->tabPrinter($acum,5);
	
	$phpPrinter->printString(utf8_decode("Total"),2,$printer,$acum,13,11,50);
	$phpPrinter->printString(utf8_decode("$"),2,$printer,$acum,13,0,300);
	$phpPrinter->printString(number_format($pedido->subtotal_pedido,2),2,$printer,$acum,13,0,320);
	$phpPrinter->tabPrinter($acum,5);
	$phpPrinter->printString(utf8_decode("Anticipo"),2,$printer,$acum,13,11,50);
	$phpPrinter->printString(utf8_decode("$"),2,$printer,$acum,13,0,300);
	$phpPrinter->printString(number_format($pedido->anticipo_pedido,2),2,$printer,$acum,13,0,320);
	$phpPrinter->tabPrinter($acum,5);
	$phpPrinter->printString(utf8_decode("Pendiente"),2,$printer,$acum,13,11,50);
	$phpPrinter->printString(utf8_decode("$"),2,$printer,$acum,13,0,300);
	$phpPrinter->printString(number_format($pedido->subtotal_pedido - $pedido->anticipo_pedido,2),2,$printer,$acum,13,0,320);
	$phpPrinter->tabPrinter($acum,15);
	$phpPrinter->printString(utf8_decode("Notas"),2,$printer,$acum,13,11,50);
	$phpPrinter->printString(utf8_decode($pedido->notas_pedido),2,$printer,$acum,13,0,300);
	$phpPrinter->tabPrinter($acum,15);
	
	$phpPrinter->printString(utf8_decode("F:____________________________________"),2,$printer,$acum,13,11,50);
	$phpPrinter->tabPrinter($acum,25);	
	
	$phpPrinter->printString(utf8_decode($MiracleApp->fechaHoraElSalvador(gmdate('d-m-Y H:i:s', strtotime('- 6 hours')),0)),2,$printer,$acum,13,11,50);
	$phpPrinter->printString(utf8_decode('Miracle v2.0 - Todos los Derechos Reservados 2012 - '.date('Y').' - Xypnos Soluciones Tecnologicas'),2,$printer,$acum,13,11,50);
	
	printer_delete_font($font);
	
	printer_end_page($printer);

	printer_end_doc($printer);

	printer_close($printer);
?>