<?php
	$this->load->library('printer');
	$this->load->library('enletras');
	
	$phpPrinter = new Printer();
	$phpInletters = new EnLetras();
	
	$phpPrinter->resetAcum();
	$acum = 0;
	
	if($printCorteFiscal):
		/*Corte*/
		$printer = printer_open("EPSON TM-U950 Receipt");

		printer_set_option($printer, PRINTER_MODE, 'RAW');
		
		printer_start_doc($printer, 'Corte Numero: '.$numero_corte);

		printer_start_page($printer);
		
		/*Body*/
		
		$font = printer_create_font('Arial', 14, 12, PRINTER_FW_THIN, false, false, false, 0);	
		printer_select_font($printer, $font);
		
		$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode($nombre_empresa)),20),1,$printer,$acum,12,14,15,10,1);
		
		printer_delete_font($font);
		
		$font = printer_create_font('Arial', 13, 9, PRINTER_FW_THIN, false, false, false, 0);	
		printer_select_font($printer, $font);
		
		$phpPrinter->tabPrinter($acum,10);
		
		$phpPrinter->printString($phpPrinter->cutString(utf8_decode($rsocial_empresa),23),1,$printer,$acum,9,13,15,10,1);
		$phpPrinter->printString($phpPrinter->cutString(utf8_decode($direcion_empresa),23),1,$printer,$acum,9,13,15,10,1);
		$phpPrinter->printString($phpPrinter->cutString(utf8_decode('NRC: '.$nrc_empresa),23),1,$printer,$acum,9,13,15,10,1);
		$phpPrinter->printString($phpPrinter->cutString(utf8_decode('NIT: '.$nit_empresa),23),1,$printer,$acum,9,13,15,10,1);
		$phpPrinter->printString($phpPrinter->cutString(utf8_decode('Resolucion'),23),1,$printer,$acum,9,13,15,10,1);
		$phpPrinter->printString($phpPrinter->cutString(utf8_decode($doc_resolucion),23),1,$printer,$acum,9,13,15,10,1);
		$phpPrinter->printString($phpPrinter->cutString(utf8_decode('Del '.$doc_desde.' Al: '.$doc_hasta),23),1,$printer,$acum,9,13,15,10,1);
		$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('Caja 1')),28),1,$printer,$acum,10,10);
		$phpPrinter->printString($phpPrinter->cutString(utf8_decode($caja),23),1,$printer,$acum,9,13,15,10,1);
		
		$phpPrinter->tabPrinter($acum,10);
		
		printer_delete_font($font); 
		
		$font = printer_create_font('Arial', 14, 12, PRINTER_FW_THIN, false, false, false, 0);	
		printer_select_font($printer, $font);
		
		$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode("TOTAL ").$tipo_corte),23),1,$printer,$acum,12,14,15,13,1);
		
		printer_delete_font($font);
		
		$font = printer_create_font('Arial', 13, 9, PRINTER_FW_THIN, false, false, false, 0);	
		printer_select_font($printer, $font);
		
		$phpPrinter->printString($phpPrinter->cutString(utf8_decode('Reporte No: '.$numero_corte),23),1,$printer,$acum,9,13,15,13,1);
		$phpPrinter->tabPrinter($acum,10);
		$phpPrinter->printString("- - - - - - - - - - - - - - - - - - - - - - - - - - -",2,$printer,$acum,9,13,0);
		$phpPrinter->tabPrinter($acum,10);
		
		/*Tickets*/
		$phpPrinter->printString(utf8_decode('Total Gravadas:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataCorteFiscal['total_ticket_grabado'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Total Exentas:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataCorteFiscal['total_ticket_exento'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Total Ventas No Sujetas:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataCorteFiscal['total_ticket_nosujeto'],2,$printer,$acum,10,0,280);
		printer_delete_font($font);
		$font = printer_create_font("Arial", 14, 12, PRINTER_FW_BOLD, false, false, false, 0);
		printer_select_font($printer, $font);
		$phpPrinter->printString(utf8_decode('Total Tickets:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString(($dataCorteFiscal['total_ticket_grabado']+$dataCorteFiscal['total_ticket_exento']+$dataCorteFiscal['total_ticket_nosujeto']),2,$printer,$acum,10,0,280);
		printer_delete_font($font);
		$font = printer_create_font("Arial", 13, 9, PRINTER_FW_MEDIUM, false, false, false, 0);
		printer_select_font($printer, $font);
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);
		
		/*Factura*/
		$phpPrinter->printString(utf8_decode('Total Gravadas:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataCorteFiscal['total_factura_grabado'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Total Exentas:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataCorteFiscal['total_factura_exento'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Total Ventas No Sujetas:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataCorteFiscal['total_factura_nosujeto'],2,$printer,$acum,10,0,280);
		printer_delete_font($font);
		$font = printer_create_font("Arial", 14, 12, PRINTER_FW_BOLD, false, false, false, 0);
		printer_select_font($printer, $font);
		$phpPrinter->printString(utf8_decode('Total Factura:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString(($dataCorteFiscal['total_factura_grabado']+$dataCorteFiscal['total_factura_exento']+$dataCorteFiscal['total_factura_nosujeto']),2,$printer,$acum,10,0,280);
		printer_delete_font($font);
		$font = printer_create_font("Arial", 13, 9, PRINTER_FW_MEDIUM, false, false, false, 0);
		printer_select_font($printer, $font);
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);
		
		/*CCF*/
		$phpPrinter->printString(utf8_decode('Total Gravadas:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataCorteFiscal['total_ccf_grabado'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Total Exentas:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataCorteFiscal['total_ccf_exento'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Total Ventas No Sujetas:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataCorteFiscal['total_ccf_nosujeto'],2,$printer,$acum,10,0,280);
		printer_delete_font($font);
		$font = printer_create_font("Arial", 14, 12, PRINTER_FW_BOLD, false, false, false, 0);
		printer_select_font($printer, $font);
		$phpPrinter->printString(utf8_decode('Total CCF:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString(($dataCorteFiscal['total_ccf_grabado']+$dataCorteFiscal['total_ccf_exento']+$dataCorteFiscal['total_ccf_nosujeto']),2,$printer,$acum,10,0,280);
		printer_delete_font($font);
		$font = printer_create_font("Arial", 13, 9, PRINTER_FW_MEDIUM, false, false, false, 0);
		printer_select_font($printer, $font);
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);
		$total_ventas = $dataCorteFiscal['total_ticket_grabado']+$dataCorteFiscal['total_ticket_exento']+$dataCorteFiscal['total_ticket_nosujeto']+$dataCorteFiscal['total_factura_grabado']+$dataCorteFiscal['total_factura_exento']+$dataCorteFiscal['total_factura_nosujeto']+$dataCorteFiscal['total_ccf_grabado']+$dataCorteFiscal['total_ccf_exento']+$dataCorteFiscal['total_ccf_nosujeto'];
		
		/*Devoluciones*/
		$phpPrinter->printString(utf8_decode('Devolucion Tickets:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataCorteFiscal['total_devolucion_ticket'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Anulacion Facturas:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataCorteFiscal['total_devolucion_factura'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Anulacion CCF:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataCorteFiscal['total_devolucion_ccf'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Anul. Nota de Cred.:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataCorteFiscal['total_devolucion_ncredito'],2,$printer,$acum,10,0,280);
		printer_delete_font($font);
		$font = printer_create_font("Arial", 14, 12, PRINTER_FW_BOLD, false, false, false, 0);
		printer_select_font($printer, $font);
		$phpPrinter->printString(utf8_decode('Total Devoluciones:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$total_devs = $dataCorteFiscal['total_devolucion_ticket']+$dataCorteFiscal['total_devolucion_factura']+$dataCorteFiscal['total_devolucion_ccf']+$dataCorteFiscal['total_devolucion_ncredito'];
		$phpPrinter->printString(("(".$total_devs.")"),2,$printer,$acum,10,0,280);
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);
		
		/*Total*/
		$phpPrinter->printString(utf8_decode('Total Ventas:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString(($total_ventas - $total_devs),2,$printer,$acum,10,0,280);
		$phpPrinter->tabPrinter($acum,5);
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);
		printer_delete_font($font);
		$font = printer_create_font("Arial", 13, 9, PRINTER_FW_MEDIUM, false, false, false, 0);
		printer_select_font($printer, $font);
		$phpPrinter->tabPrinter($acum,5);
		
		/*Contadores*/
		$phpPrinter->printString(utf8_decode('No Trans. Realizadas:'),2,$printer,$acum,10,13,0);
		$trans = $dataCorteFiscal['total_trans_ticket']+$dataCorteFiscal['total_trans_ticket_dev']+$dataCorteFiscal['total_trans_factura']+$dataCorteFiscal['total_trans_ccf'];
		$phpPrinter->printString($trans,2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Tickets Emitidos:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(($dataCorteFiscal['total_trans_ticket']+$dataCorteFiscal['total_trans_ticket_dev']),2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Devoluciones(Tickets):'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString($dataCorteFiscal['total_trans_ticket_dev'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Inicio:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString($dataCorteFiscal['ticketInicio'],2,$printer,$acum,10,0,260);
		$phpPrinter->printString(utf8_decode('Final:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString($dataCorteFiscal['ticketFin'],2,$printer,$acum,10,0,260);
		$phpPrinter->printString(utf8_decode('Facturas Emitidas:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString($dataCorteFiscal['total_trans_factura'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('CCF Emitidos:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString($dataCorteFiscal['total_trans_ccf'],2,$printer,$acum,10,0,280);
		$phpPrinter->tabPrinter($acum,5);
		
		/*Cajero y Fecha*/
		$phpPrinter->printString("Cajero: ".$cajero,2,$printer,$acum,10,13,0);
		$phpPrinter->printString($fecha,2,$printer,$acum,10,13,0);
		$phpPrinter->tabPrinter($acum,5);
		$phpPrinter->printString($phpPrinter->cutString(utf8_decode('***Operacion Finalizada***'),25),1,$printer,$acum,9,13,15,10,1);
		
		printer_delete_font($font);
		
		printer_end_page($printer);

		printer_end_doc($printer);	

		printer_close($printer);
		$phpPrinter->resetAcum();
		$acum = 0;
	endif;
	
	if($printAnexoMedio):
		/*Anexo Medio de Pago*/
		$printer = printer_open("EPSON TM-U950 Receipt Single");

		printer_set_option($printer, PRINTER_MODE, 'RAW');
		
		printer_start_doc($printer, 'Anexo 1 Medio de Pago del Corte : '.$numero_corte);

		printer_start_page($printer);
		
		/*Body*/
		
		$font = printer_create_font("Arial", 14, 12, PRINTER_FW_BOLD, false, false, false, 0);
		printer_select_font($printer, $font);
		
		$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode($nombre_empresa)),20),1,$printer,$acum,12,14,15,10,1);
		$phpPrinter->tabPrinter($acum,10);
		$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode("Anexo 1 de Corte ".$tipo_corte." numero: ".$numero_corte)),13),1,$printer,$acum,12,13,15,10,1);
		$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode("Resumen de Ingresos segun Medio")),13),1,$printer,$acum,12,13,15,10,1);
		
		printer_delete_font($font);
		
		$font = printer_create_font("Arial", 13, 9, PRINTER_FW_MEDIUM, false, false, false, 0);
		printer_select_font($printer, $font);
		
		$phpPrinter->tabPrinter($acum,10);
		$phpPrinter->printString("- - - - - - - - - - - - - - - - - - - - - - - - - - -",2,$printer,$acum,10,10,0);
		$phpPrinter->tabPrinter($acum,10);
		
		/*Efectivo*/
		$phpPrinter->printString(utf8_decode('Ingresos:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoMedio['total_ventas_efectivo'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Egresos:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString("(".$dataAnexoMedio['total_devoluciones_efectivo'].")",2,$printer,$acum,10,0,280);
		printer_delete_font($font);
		$font = printer_create_font("Arial", 14, 12, PRINTER_FW_BOLD, false, false, false, 0);
		printer_select_font($printer, $font);
		$phpPrinter->printString(utf8_decode('Efectivo:'),2,$printer,$acum,10,13,0);
		$efectivo = $dataAnexoMedio['total_ventas_efectivo'] - $dataAnexoMedio['total_devoluciones_efectivo'];
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		if($efectivo < 0){
			$phpPrinter->printString("(".$efectivo.")",2,$printer,$acum,10,0,280);	
		}else{
			$phpPrinter->printString($efectivo,2,$printer,$acum,10,0,280);		
		}
		printer_delete_font($font);
		$font = printer_create_font("Arial", 13, 9, PRINTER_FW_MEDIUM, false, false, false, 0);
		printer_select_font($printer, $font);
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);
		
		/*Cheque*/
		$phpPrinter->printString(utf8_decode('Ingresos:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoMedio['total_ventas_cheque'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Egresos:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString("(".$dataAnexoMedio['total_devoluciones_cheque'].")",2,$printer,$acum,10,0,280);
		printer_delete_font($font);
		$font = printer_create_font("Arial", 14, 12, PRINTER_FW_BOLD, false, false, false, 0);
		printer_select_font($printer, $font);
		$phpPrinter->printString(utf8_decode('Cheque:'),2,$printer,$acum,10,13,0);
		$cheque = $dataAnexoMedio['total_ventas_cheque'] - $dataAnexoMedio['total_devoluciones_cheque'];
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		if($cheque < 0){
			$phpPrinter->printString("(".$cheque.")",2,$printer,$acum,10,0,280);	
		}else{
			$phpPrinter->printString($cheque,2,$printer,$acum,10,0,280);		
		}
		printer_delete_font($font);
		$font = printer_create_font("Arial", 13, 9, PRINTER_FW_MEDIUM, false, false, false, 0);
		printer_select_font($printer, $font);
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);
		
		/*Pos*/
		$phpPrinter->printString(utf8_decode('Ingresos:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoMedio['total_ventas_pos'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Egresos:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString("(".$dataAnexoMedio['total_devoluciones_pos'].")",2,$printer,$acum,10,0,280);
		printer_delete_font($font);
		$font = printer_create_font("Arial", 14, 12, PRINTER_FW_BOLD, false, false, false, 0);
		printer_select_font($printer, $font);
		$phpPrinter->printString(utf8_decode('POS:'),2,$printer,$acum,10,13,0);
		$pos = $dataAnexoMedio['total_ventas_pos'] - $dataAnexoMedio['total_devoluciones_pos'];
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		if($pos < 0){
			$phpPrinter->printString("(".$pos.")",2,$printer,$acum,10,0,280);	
		}else{
			$phpPrinter->printString($pos,2,$printer,$acum,10,0,280);		
		}
		printer_delete_font($font);
		$font = printer_create_font("Arial", 13, 9, PRINTER_FW_MEDIUM, false, false, false, 0);
		printer_select_font($printer, $font);
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);
		
		/*Abonos*/
		$phpPrinter->printString(utf8_decode('Ingresos:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoMedio['total_ventas_cuenta'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Egresos:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString("(".$dataAnexoMedio['total_devoluciones_cuenta'].")",2,$printer,$acum,10,0,280);
		printer_delete_font($font);
		$font = printer_create_font("Arial", 14, 12, PRINTER_FW_BOLD, false, false, false, 0);
		printer_select_font($printer, $font);
		$phpPrinter->printString(utf8_decode('Abonos a Cuenta:'),2,$printer,$acum,10,13,0);
		$abonos = $dataAnexoMedio['total_ventas_cuenta'] - $dataAnexoMedio['total_devoluciones_cuenta'];
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		if($abonos < 0){
			$phpPrinter->printString("(".$abonos.")",2,$printer,$acum,10,0,280);	
		}else{
			$phpPrinter->printString($abonos,2,$printer,$acum,10,0,280);		
		}
		printer_delete_font($font);
		$font = printer_create_font("Arial", 13, 9, PRINTER_FW_MEDIUM, false, false, false, 0);
		printer_select_font($printer, $font);
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);
		
		/*Pago Electronico*/
		$phpPrinter->printString(utf8_decode('Ingresos:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoMedio['total_ventas_electronico'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Egresos:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString("(".$dataAnexoMedio['total_devoluciones_electronico'].")",2,$printer,$acum,10,0,280);
		printer_delete_font($font);
		$font = printer_create_font("Arial", 14, 12, PRINTER_FW_BOLD, false, false, false, 0);
		printer_select_font($printer, $font);
		$phpPrinter->printString(utf8_decode('Pagos Electronicos:'),2,$printer,$acum,10,13,0);
		$pagoelec = $dataAnexoMedio['total_ventas_electronico'] - $dataAnexoMedio['total_devoluciones_electronico'];
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		if($pagoelec < 0){
			$phpPrinter->printString("(".$pagoelec.")",2,$printer,$acum,10,0,280);	
		}else{
			$phpPrinter->printString($pagoelec,2,$printer,$acum,10,0,280);		
		}
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);
		
		/*Ingreso Neto*/
		$total_ingresos = $dataAnexoMedio['total_ventas_efectivo']+$dataAnexoMedio['total_ventas_cheque']+$dataAnexoMedio['total_ventas_pos']+$dataAnexoMedio['total_ventas_cuenta']+$dataAnexoMedio['total_ventas_electronico'];
		$total_egresos = $dataAnexoMedio['total_devoluciones_efectivo']+$dataAnexoMedio['total_devoluciones_cheque']+$dataAnexoMedio['total_devoluciones_pos']+$dataAnexoMedio['total_devoluciones_cuenta']+$dataAnexoMedio['total_devoluciones_electronico'];
		$phpPrinter->printString(utf8_decode('Ingreso Neto:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		if($total_ingresos < $total_egresos){
			$phpPrinter->printString("(".$total_ingresos - $total_egresos.")",2,$printer,$acum,10,0,280);	
		}else{
			$phpPrinter->printString(($total_ingresos - $total_egresos),2,$printer,$acum,10,0,280);
		}
		printer_delete_font($font);
		$font = printer_create_font("Arial", 13, 9, PRINTER_FW_MEDIUM, false, false, false, 0);
		printer_select_font($printer, $font);
		$phpPrinter->printString(utf8_decode('Dotaciones:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoMedio['dotacion'],2,$printer,$acum,10,0,280);
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);
		$font = printer_create_font("Arial", 14, 12, PRINTER_FW_BOLD, false, false, false, 0);
		printer_select_font($printer, $font);
		$phpPrinter->printString(utf8_decode('Total:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		if((($total_ingresos + $dataAnexoMedio['dotacion']) < $total_egresos)){
			$phpPrinter->printString("(".($total_ingresos + $dataAnexoMedio['dotacion']) - $total_egresos.")",2,$printer,$acum,10,0,280);	
		}else{
			$phpPrinter->printString(($total_ingresos + $dataAnexoMedio['dotacion']) - $total_egresos,2,$printer,$acum,10,0,280);		
		}
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);
		printer_delete_font($font);
		$font = printer_create_font("Arial", 13, 9, PRINTER_FW_MEDIUM, false, false, false, 0);
		printer_select_font($printer, $font);
		$phpPrinter->tabPrinter($acum,10);
		
		/*Cajero y Fecha*/
		$phpPrinter->printString("Cajero: ".$cajero,2,$printer,$acum,10,13,0);
		$phpPrinter->printString($fecha,2,$printer,$acum,10,13,0);
		$phpPrinter->tabPrinter($acum,5);
		$phpPrinter->printString($phpPrinter->cutString(utf8_decode('***Operacion Finalizada***'),25),1,$printer,$acum,9,13,15,10,1);
		
		printer_delete_font($font);
		
		printer_end_page($printer);

		printer_end_doc($printer);	

		printer_close($printer);
		$phpPrinter->resetAcum();
		$acum = 0;
	endif;
	
	if($printAnexoDocumento):	
		/*Anexo Medio de Pago*/
		$printer = printer_open("EPSON TM-U950 Receipt Single");

		printer_set_option($printer, PRINTER_MODE, 'RAW');
		
		printer_start_doc($printer, 'Anexo 2 Resumen del Ingreso segun Documento y Forma del Corte : '.$numero_corte);

		printer_start_page($printer);
		
		/*Body*/
		
		$font = printer_create_font("Arial", 14, 12, PRINTER_FW_BOLD, false, false, false, 0);
		printer_select_font($printer, $font);
		
		$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode($nombre_empresa)),20),1,$printer,$acum,12,14,15,10,1);
		$phpPrinter->tabPrinter($acum,10);
		$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode("Anexo 2 de Corte ".$tipo_corte." numero: ".$numero_corte)),13),1,$printer,$acum,12,13,15,10,1);
		$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode("Resumen del Ingreso segun Documento y Forma")),13),1,$printer,$acum,12,13,15,10,1);
		
		printer_delete_font($font);
		
		$font = printer_create_font("Arial", 13, 9, PRINTER_FW_MEDIUM, false, false, false, 0);
		printer_select_font($printer, $font);
		
		$phpPrinter->tabPrinter($acum,10);
		$phpPrinter->printString("- - - - - - - - - - - - - - - - - - - - - - - - - - -",2,$printer,$acum,10,10,0);
		$phpPrinter->tabPrinter($acum,10);
		
		/*Ingresos Contado*/
		$ingresos_contado = $dataAnexoDocumento['total_contado_sdocumento']+$dataAnexoDocumento['total_contado_factura']+$dataAnexoDocumento['total_contado_ccf']+$dataAnexoDocumento['total_contado_ticket']+$dataAnexoDocumento['total_contado_ticketrecibo']+$dataAnexoDocumento['total_contado_nremision']+$dataAnexoDocumento['total_recibos']+$dataAnexoDocumento['total_contado_nenvio']+$dataAnexoDocumento['total_abonos_pedido'];
		$phpPrinter->printString(utf8_decode('Facturas:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_contado_factura'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('CCF:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_contado_ccf'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Tickets:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_contado_ticket'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Comprobantes:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_contado_ticketrecibo'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Notas de Remision:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_contado_nremision'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Notas de Envio:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_contado_nenvio'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Recibos:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_recibos'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Ant. orden de pedidos:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_abonos_pedido'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Sin Documento:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_contado_sdocumento'],2,$printer,$acum,10,0,280);
		printer_delete_font($font);
		
		$font = printer_create_font("Arial", 14, 12, PRINTER_FW_BOLD, false, false, false, 0);
		printer_select_font($printer, $font);
		$phpPrinter->printString(utf8_decode('Ingresos Contado:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($ingresos_contado,2,$printer,$acum,10,0,280);	
		printer_delete_font($font);
		$font = printer_create_font("Arial", 13, 9, PRINTER_FW_MEDIUM, false, false, false, 0);
		printer_select_font($printer, $font);
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);
		
		/*Devoluciones Contado*/
		$devoluciones_contado = $dataAnexoDocumento['total_devolucion_sdocumento_contado']+$dataAnexoDocumento['total_devolucion_factura_contado']+$dataAnexoDocumento['total_devolucion_ccf_contado']+$dataAnexoDocumento['total_devolucion_ticket_contado']+$dataAnexoDocumento['total_devolucion_ticketrecibo_contado']+$dataAnexoDocumento['total_devolucion_nremision_contado']+$dataAnexoDocumento['total_devolucion_nenvio_contado']+$dataAnexoDocumento['total_devolucion_ncredito_contado'];
		$phpPrinter->printString(utf8_decode('Facturas:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_devolucion_factura_contado'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('CCF:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_devolucion_ccf_contado'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Tickets:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_devolucion_ticket_contado'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Comprobantes:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_devolucion_ticketrecibo_contado'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Notas de Remision:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_devolucion_nremision_contado'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Notas de Envio:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_devolucion_nenvio_contado'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Notas de Credito:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_devolucion_ncredito_contado'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Sin Documento:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_devolucion_sdocumento_contado'],2,$printer,$acum,10,0,280);
		printer_delete_font($font);
		
		$font = printer_create_font("Arial", 14, 12, PRINTER_FW_BOLD, false, false, false, 0);
		printer_select_font($printer, $font);
		$phpPrinter->printString(utf8_decode('Devs. Contado:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString("(".$devoluciones_contado.")",2,$printer,$acum,10,0,280);
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);
		
		/*Total Contado Neto*/
		$phpPrinter->printString(utf8_decode('T. CONTADO NETO:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		if(($ingresos_contado - $devoluciones_contado) < 0){
			$phpPrinter->printString("(".$ingresos_contado - $devoluciones_contado.")",2,$printer,$acum,10,0,280);	
		}else{
			$phpPrinter->printString($ingresos_contado - $devoluciones_contado,2,$printer,$acum,10,0,280);		
		}
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);
		printer_delete_font($font);
		$font = printer_create_font("Arial", 13, 9, PRINTER_FW_MEDIUM, false, false, false, 0);
		printer_select_font($printer, $font);
		
		/*Credito Generado*/
		$ingresos_credito = $dataAnexoDocumento['total_credito_sdocumento']+$dataAnexoDocumento['total_credito_factura']+$dataAnexoDocumento['total_credito_ccf']+$dataAnexoDocumento['total_credito_ticket']+$dataAnexoDocumento['total_credito_ticketrecibo']+$dataAnexoDocumento['total_credito_nremision']+$dataAnexoDocumento['total_credito_nenvio'];
		$phpPrinter->printString(utf8_decode('Facturas:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_credito_factura'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('CCF:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_credito_ccf'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Tickets:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_credito_ticket'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Comprobantes:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_credito_ticketrecibo'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Notas de Remision:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_credito_nremision'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Notas de Envio:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_credito_nenvio'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Sin Documento:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_credito_sdocumento'],2,$printer,$acum,10,0,280);
		printer_delete_font($font);
		
		$font = printer_create_font("Arial", 14, 12, PRINTER_FW_BOLD, false, false, false, 0);
		printer_select_font($printer, $font);
		$phpPrinter->printString(utf8_decode('Ingresos Credito:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($ingresos_credito,2,$printer,$acum,10,0,280);	
		printer_delete_font($font);
		$font = printer_create_font("Arial", 13, 9, PRINTER_FW_MEDIUM, false, false, false, 0);
		printer_select_font($printer, $font);
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);
		
		/*Devoluciones Credito*/
		$devoluciones_credito = $dataAnexoDocumento['total_devolucion_sdocumento_credito']+$dataAnexoDocumento['total_devolucion_factura_credito']+$dataAnexoDocumento['total_devolucion_ccf_credito']+$dataAnexoDocumento['total_devolucion_ticket_credito']+$dataAnexoDocumento['total_devolucion_ticketrecibo_credito']+$dataAnexoDocumento['total_devolucion_nremision_credito']+$dataAnexoDocumento['total_devolucion_nenvio_credito']+$dataAnexoDocumento['total_devolucion_ncredito_credito'];
		$phpPrinter->printString(utf8_decode('Facturas:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_devolucion_factura_credito'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('CCF:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_devolucion_ccf_credito'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Tickets:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_devolucion_ticket_credito'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Comprobantes:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_devolucion_ticketrecibo_credito'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Notas de Remision:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_devolucion_nremision_credito'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Notas de Envio:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_devolucion_nenvio_credito'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Notas de Credito:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_devolucion_ncredito_credito'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Sin Documento:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_devolucion_sdocumento_credito'],2,$printer,$acum,10,0,280);
		printer_delete_font($font);
		
		$font = printer_create_font("Arial", 14, 12, PRINTER_FW_BOLD, false, false, false, 0);
		printer_select_font($printer, $font);
		$phpPrinter->printString(utf8_decode('Devs. Credito:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString("(".$devoluciones_credito.")",2,$printer,$acum,10,0,280);
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);
		
		/*Total Credito Neto*/
		$phpPrinter->printString(utf8_decode('T. CREDITO NETO:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		if(($ingresos_credito - $devoluciones_credito) < 0){
			$phpPrinter->printString("(".$ingresos_credito - $devoluciones_credito.")",2,$printer,$acum,10,0,280);	
		}else{
			$phpPrinter->printString($ingresos_credito - $devoluciones_credito,2,$printer,$acum,10,0,280);		
		}
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);
		printer_delete_font($font);
		$font = printer_create_font("Arial", 13, 9, PRINTER_FW_MEDIUM, false, false, false, 0);
		printer_select_font($printer, $font);
		
		/*A cobro*/
		$ingresos_acobro = $dataAnexoDocumento['total_acobro_sdocumento']+$dataAnexoDocumento['total_acobro_factura']+$dataAnexoDocumento['total_acobro_ccf']+$dataAnexoDocumento['total_acobro_ticket']+$dataAnexoDocumento['total_acobro_ticketrecibo'];
		$phpPrinter->printString(utf8_decode('Facturas:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_acobro_factura'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('CCF:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_acobro_ccf'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Tickets:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_acobro_ticket'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Comprobantes:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_acobro_ticketrecibo'],2,$printer,$acum,10,0,280);			
		
		printer_delete_font($font);
		$font = printer_create_font("Arial", 14, 12, PRINTER_FW_BOLD, false, false, false, 0);
		printer_select_font($printer, $font);
		$phpPrinter->printString(utf8_decode('Ingresos a Cobro:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($ingresos_acobro,2,$printer,$acum,10,0,280);	
		printer_delete_font($font);
		$font = printer_create_font("Arial", 13, 9, PRINTER_FW_MEDIUM, false, false, false, 0);
		printer_select_font($printer, $font);
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);		
		
		$devoluciones_acobro = $dataAnexoDocumento['total_devolucion_sdocumento_acobro']+$dataAnexoDocumento['total_devolucion_factura_acobro']+$dataAnexoDocumento['total_devolucion_ccf_acobro']+$dataAnexoDocumento['total_devolucion_ticket_acobro']+$dataAnexoDocumento['total_devolucion_ticketrecibo_acobro'];
		$phpPrinter->printString(utf8_decode('Facturas:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_devolucion_factura_acobro'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('CCF:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_devolucion_ccf_acobro'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Tickets:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_devolucion_ticket_acobro'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Comprobantes:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_devolucion_ticketrecibo_acobro'],2,$printer,$acum,10,0,280);		
		
		printer_delete_font($font);
		$font = printer_create_font("Arial", 14, 12, PRINTER_FW_BOLD, false, false, false, 0);
		printer_select_font($printer, $font);
		$phpPrinter->printString(utf8_decode('Devs. a Cobro:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString("(".$devoluciones_acobro.")",2,$printer,$acum,10,0,280);
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);
		
		$phpPrinter->printString(utf8_decode('T. A COBRO:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		if(($ingresos_acobro - $devoluciones_acobro) < 0){
			$phpPrinter->printString("(".$ingresos_acobro - $devoluciones_acobro.")",2,$printer,$acum,10,0,280);	
		}else{
			$phpPrinter->printString($ingresos_acobro - $devoluciones_acobro,2,$printer,$acum,10,0,280);		
		}
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);
		printer_delete_font($font);
		$font = printer_create_font("Arial", 13, 9, PRINTER_FW_MEDIUM, false, false, false, 0);
		printer_select_font($printer, $font);
		
		/*Sin Ingreso*/
		$siningreso = $dataAnexoDocumento['total_singreso_sdocumento']+$dataAnexoDocumento['total_singreso_factura']+$dataAnexoDocumento['total_singreso_ccf']+$dataAnexoDocumento['total_singreso_ticket']+$dataAnexoDocumento['total_singreso_ticketrecibo'];
		
		$phpPrinter->printString(utf8_decode('Facturas:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_singreso_factura'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('CCF:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_singreso_ccf'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Tickets:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_singreso_ticket'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Comprobantes:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_singreso_ticketrecibo'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Sin Documento:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoDocumento['total_singreso_sdocumento'],2,$printer,$acum,10,0,280);
		printer_delete_font($font);
		
		$font = printer_create_font("Arial", 14, 12, PRINTER_FW_BOLD, false, false, false, 0);
		printer_select_font($printer, $font);
		$phpPrinter->printString(utf8_decode('Total sin Ingreso:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($siningreso,2,$printer,$acum,10,0,280);	
		printer_delete_font($font);
		$font = printer_create_font("Arial", 13, 9, PRINTER_FW_MEDIUM, false, false, false, 0);
		printer_select_font($printer, $font);
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);
		
		$phpPrinter->tabPrinter($acum,10);
		
		/*Cajero y Fecha*/
		$phpPrinter->printString("Cajero: ".$cajero,2,$printer,$acum,10,13,0);
		$phpPrinter->printString($fecha,2,$printer,$acum,10,13,0);
		$phpPrinter->tabPrinter($acum,5);
		$phpPrinter->printString($phpPrinter->cutString(utf8_decode('***Operacion Finalizada***'),25),1,$printer,$acum,9,13,15,10,1);
		
		printer_delete_font($font);
		
		printer_end_page($printer);

		printer_end_doc($printer);	

		printer_close($printer);
		$phpPrinter->resetAcum();
		$acum = 0;
	endif;
	
	if($printAnexoTipo):
		/*Anexo Tipo de Ingreso*/
		$printer = printer_open("EPSON TM-U950 Receipt Single");

		printer_set_option($printer, PRINTER_MODE, 'RAW');
		
		printer_start_doc($printer, 'Anexo 3 Tipo de Ingreso del Corte : '.$numero_corte);
		
		printer_start_page($printer);
		
		/*Body*/
		$font = printer_create_font("Arial", 14, 12, PRINTER_FW_BOLD, false, false, false, 0);
		printer_select_font($printer, $font);
		
		$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode($nombre_empresa)),20),1,$printer,$acum,12,13,15,10,1);
		$phpPrinter->tabPrinter($acum,10);
		$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode("Anexo 3 de Corte ".$tipo_corte." numero: ".$numero_corte)),13),1,$printer,$acum,12,13,15,10,1);
		$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode("Tipo de Ingreso")),13),1,$printer,$acum,12,13,15,10,1);
		
		printer_delete_font($font);
		
		$font = printer_create_font("Arial", 13, 9, PRINTER_FW_MEDIUM, false, false, false, 0);
		printer_select_font($printer, $font);
		
		$phpPrinter->tabPrinter($acum,10);
		$phpPrinter->printString("- - - - - - - - - - - - - - - - - - - - - - - - - - -",2,$printer,$acum,10,10,0);
		$phpPrinter->tabPrinter($acum,10);
		
		$ventas_netas_contado = $dataAnexoTipo['total_venta_contado']-$dataAnexoTipo['total_dev_contado'];
		$phpPrinter->printString(utf8_decode('Ventas:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoTipo['total_venta_contado'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Devoluciones:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString("(".$dataAnexoTipo['total_dev_contado'].")",2,$printer,$acum,10,0,280);
		printer_delete_font($font);
		
		/*Ventas netas contado*/
		$font = printer_create_font("Arial", 14, 12, PRINTER_FW_BOLD, false, false, false, 0);
		printer_select_font($printer, $font);
		$phpPrinter->printString(utf8_decode('Ventas netas contado:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		if($ventas_netas_contado < 0){
			$phpPrinter->printString("(".$ventas_netas_contado.")",2,$printer,$acum,10,0,280);	
		}else{
			$phpPrinter->printString($ventas_netas_contado,2,$printer,$acum,10,0,280);		
		}
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);

		$phpPrinter->printString(utf8_decode('Abono a crédito:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoTipo['total_abonos_cred_contado'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Ant. a pedido:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoTipo['total_abonos_pedido_contado'],2,$printer,$acum,10,0,280);		
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);
		$phpPrinter->printString(utf8_decode('TOTAL CONTADO NETO:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		if(($ventas_netas_contado+$dataAnexoTipo['total_abonos_cred_contado']+$dataAnexoTipo['total_abonos_pedido_contado']) < 0){
			$phpPrinter->printString("(".($ventas_netas_contado+$dataAnexoTipo['total_abonos_cred_contado']+$dataAnexoTipo['total_abonos_pedido_contado']).")",2,$printer,$acum,10,0,280);	
		}else{
			$phpPrinter->printString(($ventas_netas_contado+$dataAnexoTipo['total_abonos_cred_contado']+$dataAnexoTipo['total_abonos_pedido_contado']),2,$printer,$acum,10,0,280);		
		}
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);
		printer_delete_font($font);
		
		$font = printer_create_font("Arial", 13, 9, PRINTER_FW_MEDIUM, false, false, false, 0);
		printer_select_font($printer, $font);
		
		$phpPrinter->printString(utf8_decode('Dotacion:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoTipo['dotacion_contado'],2,$printer,$acum,10,0,280);
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);
		printer_delete_font($font);
		
		$font = printer_create_font("Arial", 14, 12, PRINTER_FW_BOLD, false, false, false, 0);
		printer_select_font($printer, $font);
		
		$phpPrinter->printString(utf8_decode('TOTAL CONTADO:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		if(($ventas_netas_contado+$dataAnexoTipo['total_abonos_cred_contado']+$dataAnexoTipo['total_abonos_pedido_contado']+$dataAnexoTipo['dotacion_contado']) < 0){
			$phpPrinter->printString("(".($ventas_netas_contado+$dataAnexoTipo['total_abonos_cred_contado']+$dataAnexoTipo['total_abonos_pedido_contado']+$dataAnexoTipo['dotacion_contado']).")",2,$printer,$acum,10,0,280);	
		}else{
			$phpPrinter->printString(($ventas_netas_contado+$dataAnexoTipo['total_abonos_cred_contado']+$dataAnexoTipo['total_abonos_pedido_contado']+$dataAnexoTipo['dotacion_contado']),2,$printer,$acum,10,0,280);		
		}
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);
		printer_delete_font($font);
		
		$font = printer_create_font("Arial", 13, 9, PRINTER_FW_MEDIUM, false, false, false, 0);
		printer_select_font($printer, $font);
		
		$ventas_netas_credito = $dataAnexoTipo['total_venta_credito']-$dataAnexoTipo['total_dev_credito'];
		$phpPrinter->printString(utf8_decode('Ventas Crédito:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoTipo['total_venta_credito'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('Dev. C/Abono Crédito:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString("(".$dataAnexoTipo['total_dev_credito'].")",2,$printer,$acum,10,0,280);
		printer_delete_font($font);
		
		/*Ventas netas credito*/
		$font = printer_create_font("Arial", 14, 12, PRINTER_FW_BOLD, false, false, false, 0);
		printer_select_font($printer, $font);
		$phpPrinter->printString(utf8_decode('Ventas netas credito:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		if($ventas_netas_credito < 0){
			$phpPrinter->printString("(".$ventas_netas_credito.")",2,$printer,$acum,10,0,280);	
		}else{
			$phpPrinter->printString($ventas_netas_credito,2,$printer,$acum,10,0,280);		
		}
		printer_draw_line($printer, 0, $phpPrinter->getAcum()+12, 340, $phpPrinter->getAcum()+12);

		$phpPrinter->printString(utf8_decode('Abonos a créditos:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		$phpPrinter->printString($dataAnexoTipo['total_abonos_cred_contado'],2,$printer,$acum,10,0,280);
		$phpPrinter->printString(utf8_decode('EVOLUCIÓN DEL CRÉDITO:'),2,$printer,$acum,10,13,0);
		$phpPrinter->printString(utf8_decode('$'),2,$printer,$acum,10,0,260);
		if(($ventas_netas_credito+$dataAnexoTipo['total_abonos_cred_contado']) < 0){
			$phpPrinter->printString("(".($ventas_netas_credito+$dataAnexoTipo['total_abonos_cred_contado']).")",2,$printer,$acum,10,0,280);	
		}else{
			$phpPrinter->printString(($ventas_netas_credito+$dataAnexoTipo['total_abonos_cred_contado']),2,$printer,$acum,10,0,280);		
		}
		
		printer_delete_font($font);
		
		$font = printer_create_font("Arial", 13, 9, PRINTER_FW_MEDIUM, false, false, false, 0);
		printer_select_font($printer, $font);
		
		$phpPrinter->tabPrinter($acum,10);
		
		/*Cajero y Fecha*/
		$phpPrinter->printString("Cajero: ".$cajero,2,$printer,$acum,10,13,0);
		$phpPrinter->printString($fecha,2,$printer,$acum,10,13,0);
		$phpPrinter->tabPrinter($acum,5);
		$phpPrinter->printString($phpPrinter->cutString(utf8_decode('***Operacion Finalizada***'),25),1,$printer,$acum,9,13,15,10,1);
		
		printer_delete_font($font);
		
		printer_end_page($printer);

		printer_end_doc($printer);	

		printer_close($printer);
		$phpPrinter->resetAcum();
		$acum = 0;
	endif;
?>