var Usuarios=function(){
	this.baseUrl=null;
	this.scroll=true;
	this.test=function(){
		console.log('La clase Usuarios ha sido instanciado correctamente');
	}
	this.setUrl=function(url){
		this.baseUrl=url;
	}
	
	this.guardar=function(e,action){
		var sender = '#guardar-usuario';
		$(sender).attr('disabled','disabled');
		var parent = this;
		var valid = true;		
		var contCheck = 0;
		
		$('#formSaveUser input[type="checkbox"]').each(function(){
			if($(this).is(':checked')){
				$(this).prev().val('true');
				contCheck++;
			}else{
				$(this).prev().val('false');
			}
		});
		
		if(contCheck < 1){
			swal({
				title: "!No has agregado ningun permiso!",
				text: "No ha seleccionado ningun permiso, necesitas agregar al menos uno para guardar el Usuario",
				type: "error",
				confirmButtonColor: "#DD6B55",
				confirmButtonText: "Ok",
				closeOnConfirm: true,
				html: true
			},
			function(){
					
			});
			valid = false;
			$(sender).removeAttr('disabled');
		}
		
		var options = {
			beforeSubmit:function(){
				
			},
			success:function(responseText){
				toastr.options = {
				  "closeButton": true,
				  "progressBar": true,
				  "positionClass": "toast-top-right"
				}
				toastr.success('El usuario '+responseText.split("‡")[0]+' se ha '+action+' en la Base de Datos del Sistema');
				parent.cargar(true,0);
				parent.detalles(responseText.split("‡")[1]);
				Custombox.close();
			}
		};
		
		if(valid){
			$('#formSaveUser').ajaxSubmit(options);
		}			
		
		e.preventDefault();	
	}
	
	this.guardar_meta=function(e,action){
		var sender = '#guardar-meta';
		$(sender).attr('disabled','disabled');
		var parent = this;
		
		var options = {
			beforeSubmit:function(){
				
			},
			success:function(responseText){
				toastr.options = {
				  "closeButton": true,
				  "progressBar": true,
				  "positionClass": "toast-top-right"
				}
				toastr.success('La Meta '+responseText+' se ha '+action+' en la Base de Datos del Sistema');
				parent.cargar_metas();
				Custombox.close();
			}
		};
		
		$('#formSave').ajaxSubmit(options);		
		
		e.preventDefault();	
	}
	
	this.cargar_metas=function(){
		var tableCotizaciones = $('#tableMetas').DataTable();
		tableCotizaciones.ajax.reload();
		setTimeout(function () { $('div.dataTables_filter input').focus(); }, 100);
	}
	
	this.cargar=function(reset,offset){
		if(this.scroll){
			this.scroll=false;
			this.loader($('#usuarios-lista-table tbody tr.tr-loader td:first'),'start');
			if(reset){
				$("#usuarios-lista-table").find("tr:not(.tr-loader)").remove();
			}
			jQuery.ajaxSetup({async:false});
			$.get(this.baseUrl+"administracion/cargar_usuarios",{search:$('#usuarios-search-str').val(),offset:offset},function(usuarios){
				if(usuarios){
					$.each(usuarios,function(i,usuario){
						if(usuario.id>0){
							var estado = "Activo";
							if(usuario.estado == 1){
								estado = "Inactivo";
							}
							var usuarioHtml="<tr id='usuario-"+usuario.id+"'><td><h4>"+usuario.nombre+"</h4><small>"+usuario.username+"</small></td><td class='contact-type'><i class='fa fa-user'></i></td><td> "+estado+"</td></tr>"
							$(usuarioHtml).insertBefore('.tr-loader');
						}
					});
				}else{
					toastr.options = {
					  "closeButton": true,
					  "positionClass": "toast-bottom-right"
					}
					toastr.warning('&iexcl;No se han encontrado más usuarios en la base de datos del sistema!');
				}
			},"json");
			this.loader($('#usuarios-lista-table tbody tr.tr-loader td:first'),'stop');
			this.scroll=true;
		}
	}
	this.detalles=function(id){
		$("#usuarios-detalles-ajax-wrapper").html('');
		this.loader($('#usuarios-detalles-ajax-wrapper'),'start');
		$("#usuarios-detalles-info-wrapper").hide();
		$.get(this.baseUrl+"administracion/detalles_usuario",{id:id},function(usuario){
			$("#usuarios-detalles-ajax-wrapper").html(usuario);
		},"html");
	}
	
	this.actualizarPass=function(e){
		var sender = '#actualizar-password';
		$(sender).attr('disabled','disabled');
		var parent = this;
		var valid = true;
		
		if(CryptoJS.SHA1($('#actual_enter_password').val()) != $('#actual_password').val()){
			swal({
				title: "!Contrase&ntilde;a Actual Incorrecta!",
				text: "Verifique que la contrase&ntilde;a ingresada sea la misma",
				type: "error",
				confirmButtonColor: "#DD6B55",
				confirmButtonText: "Ok",
				closeOnConfirm: true,
				html: true
			},
			function(){
				setTimeout(function () { $("#actual_enter_password").focus(); }, 100);			
			});
			valid = false;
			$(sender).removeAttr('disabled');
		}else if($('.passEvaluate').text() == 'Contraseña muy corta'){
			swal({
				title: "!Contrase&ntilde;a Muy Debil!",
				text: "La Contrase&ntilde;a debe de tener mas de 6 caracteres, se recomienda incluir letras mayusculas, numeros y caracteres especiales para mayor seguridad",
				type: "error",
				confirmButtonColor: "#DD6B55",
				confirmButtonText: "Ok",
				closeOnConfirm: true,
				html: true
			},
			function(){
				setTimeout(function () { $("#new_password").focus(); }, 100);			
			});
			valid = false;
			$(sender).removeAttr('disabled');
		}else if($('#new_password').val() != $('#confirm_password').val()){
			swal({
				title: "!Contrase&ntilde;as no Coinciden!",
				text: "Las Contrase&ntilde;as no coinciden, favor verifique que ambos valores ingresados sean iguales",
				type: "error",
				confirmButtonColor: "#DD6B55",
				confirmButtonText: "Ok",
				closeOnConfirm: true,
				html: true
			},
			function(){	
				setTimeout(function () { $("#new_password").focus(); }, 100);
			});
			valid = false;
			$(sender).removeAttr('disabled');
		}
		
		var options = {
			beforeSubmit:function(){
				
			},
			success:function(responseText){
				toastr.options = {
				  "closeButton": true,
				  "progressBar": true,
				  "positionClass": "toast-top-right"
				}
				toastr.success('La Contrase&ntilde;a se ha actualizado en la Base de Datos del Sistema');
				Custombox.close();
			}
		};
		
		if(valid){
			$('#formChangePass').ajaxSubmit(options);
		}			
		
		e.preventDefault();	
	}
	
	this.eliminar=function(id,nombre){
		var _this=this;
		swal({
		  title: "¿Eliminar "+nombre+"?",
		  text: "Esta acción eliminará definitivamente al usuario. ¿Esta seguro que desea continuar?",
		  type: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#DD6B55",
		  cancelButtonText: "Cancelar",
		  confirmButtonText: "Si, Eliminar"
		},
		function(){
			$.get(_this.baseUrl+"administracion/eliminar_usuario",{id:id},function(deleted){ /*7266-3489*/
				if(deleted){
					toastr.options = {
					  "closeButton": true,
					  "progressBar": true,
					  "positionClass": "toast-top-right"
					}
					toastr.success('El usuario <b>'+nombre+'</b> se ha eliminado de la Base de Datos del Sistema.');
					$("#usuarios-detalles-ajax-wrapper").html('');
					$("#usuarios-detalles-info-wrapper").show();
					_this.cargar(true,0);
				}
			},'text');
		});
	}
	
	this.eliminar_meta=function(id,nombre){
		var _this=this;
		swal({
		  title: "¿Eliminar meta de "+nombre+"?",
		  text: "Esta acción eliminará definitivamente esta meta. ¿Esta seguro que desea continuar?",
		  type: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#DD6B55",
		  cancelButtonText: "Cancelar",
		  confirmButtonText: "Si, Eliminar"
		},
		function(){
			$.get(_this.baseUrl+"administracion/eliminar_meta",{id:id},function(deleted){ /*7266-3489*/
				if(deleted){
					toastr.options = {
					  "closeButton": true,
					  "progressBar": true,
					  "positionClass": "toast-top-right"
					}
					toastr.success('La meta <b>'+nombre+'</b> se ha eliminado de la Base de Datos del Sistema.');
					_this.cargar_metas(true,0);
				}
			},'text');
		});
	}
	
	this.activar=function(id,nombre,estado){
		var estadoText = "desactivado";
		var estadoSwal = "Desactivar";
		var estadoSwalText = "Esta acción desactivara al usuario y por lo tanto no podra ingresar al Sistema ¿Esta seguro que desea continuar?";
		if(estado == 1){
			estadoText = "activado";
			estadoSwal = "Activar";
			estadoSwalText = "Esta acción reactivara al usuario y por lo tanto podra ingresar al Sistema nuevamente ¿Esta seguro que desea continuar?";
		}
		var _this=this;
		swal({
		  title: estadoSwal+" "+nombre+"?",
		  text: estadoSwalText,
		  type: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#DD6B55",
		  cancelButtonText: "Cancelar",
		  confirmButtonText: "Si, "+estadoSwal
		},
		function(){
			$.get(_this.baseUrl+'administracion/activar_usuario?id='+id+'&estado='+estado)
			.done(function(){
				toastr.options = {
				  "closeButton": true,
				  "progressBar": true,
				  "positionClass": "toast-top-right"
				}
				toastr.success('El usuario <b>'+nombre+'</b> se ha '+estadoText+' en la Base de Datos del Sistema.');
				_this.cargar(true,0);
				_this.detalles(id);
			}); 
		});
	}
	
	this.loader=function($wrapper,action){
		if(action=='start'){
			var load=$(document.createElement('div')).attr('class','sk-spinner sk-spinner-fading-circle');
			for(var i=1; i<=12; i++){
				$(document.createElement('div')).attr('class','sk-circle'+i+' sk-circle').appendTo(load);
			}
			load.appendTo($wrapper);
		}else if('stop'){
			$wrapper.find('.sk-spinner').remove();
		}
	}
}
var usuarios = new Usuarios();