var Pedidosapp=function(){
	this.baseUrl=null;
	this.config=null;
	this.setUrl=function(url){
		this.baseUrl=url;
	},
	this.setConfig=function(conf){
		this.config=conf;
	},
	this.validador={
		productos:function(){
			return {
				result:$("#nuevo-pedido-app-productos-wrapper table tr").size()>0,
				msg:"Por favor agregue productos a la lista",
				type:1,
				action:function(){
					$("#nuevo-pedido-app-producto-sku").focus();
				}
			}
		},
		anticipoInvalido:function(){
			return {
				result:parseFloat($("#nuevo-pedido-app-restante").val()) >= 0,
				msg:"Ingrese una cantidad valida para el anticipo",
				type:1,
				action:function(){
					$("#nuevo-pedido-app-anticipo").focus();
				}
			}
		},
		documento:function(){
			return {
				result:parseFloat($("#nuevo-pedido-app-documento").val()) >= 0,
				msg:"Seleccione un documento de impresion",
				type:1,
				action:function(){
					$("#nuevo-pedido-app-documento").focus();
				}
			}
		},
		documentosTransitorioCredito:function(){
			return {
				result:($("#nuevo-pedido-app-documento").val()==1 || $("#nuevo-pedido-app-documento").val()==2 || $("#nuevo-pedido-app-documento").val()==3?true:false),
				msg:"Los documento transitorios estan permitidos solo para pedidos al cr&eacute;dito, por favor seleccione otro tipo de documento",
				type:1,
				action:function(){
					$("#nuevo-pedido-app-documento").focus();
				}
			}
		},
		documentosFacturadosContado:function(){
			return {
				result:($("#nuevo-pedido-app-documento").val()!=1 && $("#nuevo-pedido-app-documento").val()!=2 && $("#nuevo-pedido-app-documento").val()!=3?true:false),
				msg:"Los documento de facturacion definitiva estan permitidos solo para pedidos al contado, por favor seleccione otro tipo de documento",
				type:1,
				action:function(){
					$("#nuevo-pedido-app-documento").focus();
				}
			}
		},
		cliente:function(){
			return {
				result:($.trim($("#nuevo-pedido-app-cliente").val())!=''?true:false),
				msg:"Por favor seleccione un cliente",
				type:1,
				action:function(){
					$("#nuevo-pedido-app-cliente-buscar-btn").focus();
				}
			}
		},
		clienteNombre:function(){
			return {
				result:($.trim($("#nuevo-pedido-app-cliente-text").val())!=""?true:false),
				msg:"Por favor ingrese un nombre o seleccione un cliente",
				type:1,
				action:function(){
					$("#nuevo-pedido-app-cliente-text").focus();
				}
			}
		},
		clienteNRC:function(){
			return {
				result:($.trim($("#nuevo-pedido-cliente-nrc").val())!=""?true:false),
				msg:"Por favor ingrese el N&uacute;mero de Registro Comercial (NRC)",
				type:2,
				action:function(){
					$('#nuevo-pedido-cliente-docs').on('shown.bs.modal', function () {
						$("#nuevo-pedido-cliente-nrc").focus();
					});
					$('#nuevo-pedido-cliente-docs').modal("show");
					$("#nuevo-pedido-cliente-nrc").focus();
				}
			}
		},
		clienteDUIoNIT:function(){
			return {
				result:($.trim($("#nuevo-pedido-cliente-dui").inputmask('unmaskedvalue')).length == 9 || $.trim($("#nuevo-pedido-cliente-nit").inputmask('unmaskedvalue')).length == 14?true:false),
				msg:"Por favor ingrese el N&uacute;mero de Documento Unico de Identidad (DUI) 0 el N&uacute;mero de Identificaci&oacute;n tributaria (NIT) v&aacute;lido",
				type:2,
				action:function(){
					$('#nuevo-pedido-cliente-docs').on('shown.bs.modal', function () {
						$("#nuevo-pedido-cliente-dui").focus();
					});
					$('#nuevo-pedido-cliente-docs').modal("show");
					$("#nuevo-pedido-cliente-dui").focus();
				}
			}
		},
		creditoAutorizado:function(){
			return {
				result:($("#nuevo-pedido-app-cliente-text").attr('data-credito')=='1'?true:false),
				msg:"El cliente seleccionado no posee cr&eacute;ditos autorizados",
				type:1
			}
		},
		creditoMontoAutorizado:function(){
			var disponible=0;
			jQuery.ajaxSetup({async:false});
			$.get(window.location.protocol+"//"+window.location.host+"/"+window.location.pathname.split('/')[1]+'/clientes/getcreditodisponible',{cliente:$.trim($("#nuevo-pedido-app-cliente").val())},function(disp){
				disponible=parseFloat(disp);
			},'text');
			jQuery.ajaxSetup({async:true});
			return {
				result:(parseFloat($('#nuevo-pedido-app-totales-wrapper .totalval').attr('data-value')) <= disponible?true:false),
				msg:"El monto de esta transacci&oacute;n supera el cr&eacute;dito disponible ($ "+disponible+") para el cliente seleccionado",
				type:1
			}
		}
	}
	this.test=function(){
		console.log('La clase Pedidosapp ha sido instanciado correctamente');
	}
	this.cargarTrans=function(){
		var tableTrans = $('#pedidos-table').DataTable();
		tableTrans.ajax.reload();
		setTimeout(function () { $('div.dataTables_filter input').focus(); }, 100);
	 }
	this.validarPedido=function($sender){
		if($sender){
			$sender.attr('disabled','disabled');
		}
		var _this=this;
		var reglas={productos:this.validador.productos(),clienteNombre:this.validador.clienteNombre(),anticipo:this.validador.anticipoInvalido(),documento:this.validador.documento()}
		var reglasTipo1=2;
		var reglasTipo2=0;
		/*Contado en documento transitorios*/
		if($("#nuevo-pedido-app-condicion").val()==0 && this.config.transacciones_validar_credito_transitorios){
			reglas.documentosTransitorioCredito=this.validador.documentosTransitorioCredito();
			reglasTipo1+=1;
		}		
		/*Contado en documento transitorios*/
		if($("#nuevo-pedido-app-condicion").val()==1 && this.config.transacciones_validar_contado_facturados){
			reglas.documentosFacturadosContado=this.validador.documentosFacturadosContado();
			reglasTipo1+=1;
		}
		/*Pedido credito nivel 1*/
		if($("#nuevo-pedido-app-condicion").val()==1){
			reglas.cliente=this.validador.cliente();
			reglas.creditoAutorizado=this.validador.creditoAutorizado();
			reglas.creditoMontoAutorizado=this.validador.creditoMontoAutorizado();
			delete reglas.clienteNombre;
			reglasTipo1+=2;
		}
		/*Pedido con CCF*/
		if($("#nuevo-pedido-app-documento").val()==2){
			reglas.clienteNRC=this.validador.clienteNRC();
			reglasTipo2+=1;
		}
		/*Pedido mayor a 200 Factura*/
		if(parseFloat($('#nuevo-pedido-app-totales-wrapper .totalTotal .totalval').attr('data-value'))>=200.00 && $("#nuevo-pedido-app-documento").val()==1){
			reglas.clienteDUI=this.validador.clienteDUIoNIT();
			reglasTipo2+=1;
		}
		/*Pedido mayor a 200 Ticket*/
		if(parseFloat($('#nuevo-pedido-app-totales-wrapper .totalTotal .totalval').attr('data-value'))>=200.00 && $("#nuevo-pedido-app-documento").val()==3){
			reglas.clienteDUI=this.validador.clienteDUIoNIT();
			reglasTipo2+=1;
		}
		
		var valid=true;
		var reglasCountTipo1=0;
		var reglasCountTipo2=0;
		var errorInType=null;
		$.each(reglas,function(i,regla){
			if(regla.type){
				if(regla.type==1)
					reglasCountTipo1+=1;
				else if(regla.type==2)
					reglasCountTipo2+=1;
			}
			if(!regla.result){
				valid=regla.result;
				if(regla.msg)
					_this.showMsgPedido('error',regla.msg);
				if(regla.action)
					regla.action();
				if(regla.type)
					errorInType=regla.type;
			}else{
				if(reglasCountTipo2==reglasTipo2)
					$('#nuevo-pedido-cliente-docs').modal("hide");
			}
			return valid;
		});
		if(valid){
			$("#nuevo-pedido-confirm-total").text(parseFloat($('#nuevo-pedido-app-totales-wrapper .totalTotal .totalval').attr('data-value')));
			$('#nuevo-pedido-confirmar').on('shown.bs.modal',function(){
				$("#nuevo-pedido-confirmar-guardar-btn").focus();
				$("#guardar-pedido-app-btn").attr('disabled','disabled');
			});
			$("#nuevo-pedido-confirmar").modal({backdrop: 'static', keyboard: false});
			$("#nuevo-pedido-confirmar").modal("show"); 
		}
		else{
			if(errorInType==1)
				$("#guardar-pedido-app-btn").removeAttr('disabled');
			else if(errorInType==2)
				$("#nuevo-pedido-doc-guardar-btn").removeAttr('disabled');
		}
	}
	this.cancelarValidarPedido=function(){
		$("#guardar-pedido-app-btn").removeAttr('disabled');
		$("#nuevo-pedido-doc-guardar-btn").removeAttr('disabled');
		$("#nuevo-pedido-confirmar-guardar-btn").removeAttr('disabled');
		$("#nuevo-pedido-cancelar-guardar-btn").removeAttr('disabled');
	}
	
	this.processPedido=function(){
		var _this=this;
		$("#nuevo-pedido-confirmar-guardar-btn").attr('disabled','disabled');
		$("#nuevo-pedido-cancelar-guardar-btn").attr('disabled','disabled');
		$("#nuevo-pedido-procesar-status-text").text('Guardando pedido...');
		$("#nuevo-pedido-procesar-status-icon").html("<i class='fa fa-spinner fa-5x'></i>");
		
		var productos=[];
		var totales=[];
		var products=$("#nuevo-pedido-app-productos-wrapper table tr");
		var totals=$("#nuevo-pedido-app-totales-wrapper tr");
		$.each(products,function(index,product){
			productos.push({descarga:true,id:$(product).attr('data-id'),pre:$(product).attr('data-pre'),uequiv:$(product).attr('data-uequiv'),desc:$(product).find('.table-desc').attr('data-value'),cant:$(product).find('.table-cant').attr('data-value'),costo:$(product).find('.table-precio').attr('data-value'),tipoventa:$(product).find('.table-tipoventa').attr('data-value')});
		});
		$.each(totals,function(index,total){
			switch($(total).attr('class')){
				case 'totalSumas':totales.push({totalSumas:$(total).find('.totalval').attr('data-value')});break;
				case 'totalGrabadas':totales.push({totalGrabadas:$(total).find('.totalval').attr('data-value')});break;
				case 'totalIVA':totales.push({totalIVA:$(total).find('.totalval').attr('data-value')});break;
				case 'totalIVApercibido':totales.push({totalIVApercibido:$(total).find('.totalval').attr('data-value')});break;
				case 'totalIVAretenido':totales.push({totalIVAretenido:$(total).find('.totalval').attr('data-value')});break;
				case 'totalSubtotal':totales.push({totalSubtotal:$(total).find('.totalval').attr('data-value')});break;
				case 'totalNS':totales.push({totalNS:$(total).find('.totalval').attr('data-value')});break;
				case 'totalExento':totales.push({totalExento:$(total).find('.totalval').attr('data-value')});break;
				case 'totalTotal':totales.push({totalTotal:$(total).find('.totalval').attr('data-value')});break;
			}
		});
		$.post(_this.baseUrl+'transacciones/guardarpedidoapp', {
			idpedido:$("#id-pedidoapp").val(),
			cliente:$('#nuevo-pedido-app-cliente').val(),
			clientetxt:$.trim($("#nuevo-pedido-app-cliente-text").val()),
			documento:$('#nuevo-pedido-app-documento').val(),
			vendedor:$('#nuevo-pedido-app-vendedor').val(),
			fecha:$('#nuevo-pedido-app-fecha').val(),
			notas:$('#nuevo-pedido-app-notas').val(),
			anticipo:$('#nuevo-pedido-app-anticipo').val(),
			productos:JSON.stringify(productos),
			totales:JSON.stringify(totales)})
		.done(function(pedido) {
				$("#nuevo-pedido-procesar-status-text").html('El pedido se ha guardado! <br> <strong style="font-size:32px">'+pedido+'</strong>');
				$("#nuevo-pedido-procesar-status-icon").html("<i style='color:#1AB394;' class='fa fa-check-circle fa-5x'></i>");
				$("#nuevo-pedido-confirmar-guardar-btn").hide();
				$("#nuevo-pedido-cancelar-guardar-btn").hide();
				$("#nuevo-pedido-confirmar-salir-btn").show();
				$("#nuevo-pedido-confirmar-salir-btn").focus();
				$("#id-pedidoapp").val(pedido);
				$("#nuevo-pedido-confirmar-imprimir-btn").show();
			});
	}
	this.facturar=function(id){
		var _this=this;
		Custombox.open({
			target:_this.baseUrl+'transacciones/facturacionapp?pedido='+id, 
			effect: 'fadein',
			overlayClose:false,
			complete:function(){
				/* $(".modal-body input:text").first().focus(); */
			}
		});
	}
	this.reimprimir=function(id){
		var _this=this;
		url="transacciones/printpedido";
		/* $.get(_this.baseUrl+url,{id:id},function(e){
			_this.showMsgPedido("info","Se ha enviado la orden");
		},"text"); */
		$.post(_this.baseUrl+url,{
			id:id}
		).done(function(dataPrint){
			var urlLocal="http://localhost/miracleprint/pedido.php";
			
			$.post(urlLocal,{
				dataPrint:dataPrint
			})
			.done(function(response){                
				
			});
			
			_this.showMsgPedido("info","Se ha enviado la orden");
			
		});
	}
	this.modificar=function(id){
		var _this=this;
		Custombox.open({
            target:_this.baseUrl+"transacciones/pedido_nuevo?id="+id,
            effect: 'fadein',
			overlayClose:false,
			complete:function(){
					$(".modal-body input:text").first().focus();
				}
        });
	}
	this.eliminar=function(id){
		var _this=this;
		swal({
		  title: "Cancelar Pedido",
		  text: "El pedido No.:"+id+" se cancelar&aacute; y no podra efectuar cambios o facturarlo, &iquest;Desea continuar?",
		  html: true,
		  type: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#DD6B55",
		  cancelButtonText: "Cancelar",
		  confirmButtonText: "Si, Cancelar",
		},
		function(isconfirm){
			if(isconfirm){
				$.get(_this.baseUrl+'transacciones/cancelarpedido',{id:id},function(deleted){
					if(deleted){
						toastr.options = {
						  "closeButton": true,
						  "progressBar": true,
						  "positionClass": "toast-top-right"
						}
						toastr.success('El pedido No.<b>'+id+'</b> se ha cancelado.');
						_this.cargarTrans();
					}
				},'text');
			}
		});
	}
	this.showMsgPedido=function(tipo, mensaje){
		toastr.options = {
			"closeButton": true,
			"progressBar": true,
			"positionClass": "toast-top-right"
		}
		toastr[tipo](mensaje);
	}
}
var pedidosapp = new Pedidosapp();