<?php
	$this->load->library('fpdf');
	
	$GLOBALS['dataArray'] = array(
        'Empresa' => $configs['NombreEmpresa'],
        'Direccion' => $configs['DireccionEmpresa'],
        'Logo' => base_url($configs['LogoEmpresa']),
		'FechaDesde' => $fechadesde,
        'FechaHasta' => $fechahasta
    );
	
	class PDF extends FPDF{
    
        function Header(){
            global $dataArray;
			$fechadesde = new DateTime($dataArray['FechaDesde']);
			$fechahasta = new DateTime($dataArray['FechaHasta']);
			
            $this->Image($dataArray['Logo'],250,5,25);
            $this->SetFont('Arial','B',12);
            $this->SetY(6);
            $this->Cell(0,8,utf8_decode('Reporte de Ventas al Credito'),0,1,'C');
            $this->SetFont('Arial','B',9);
            $this->SetY(12);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Empresa'])),0,1,'C');
            $this->SetY(17);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Direccion'])),0,1,'C');
            $this->Ln(3);
			
			$this->SetFont('Arial','',9);
            $this->Cell(20,8,'Periodo',0,0,'L');
			$this->SetFont('Arial','B',9);
            $this->Cell(50,8,$fechadesde->format('d-m-Y').' - '.$fechahasta->format('d-m-Y'),0,1,'L');
			$this->Ln(3);
        }
        
        function Footer(){
            $this->SetY(-25);
            $this->SetFont('Arial','I',7);
            $this->Cell(200,6,utf8_decode('Pagina '.$this->PageNo().'/{nb}'),0,0,'L');
            $this->Cell(60,6,utf8_decode(gmdate('d-m-Y H:i:s', strtotime('- 6 hours'))),0,1,'R');
            $this->Cell(60,6,utf8_decode('Miracle v1.5 - Todos los Derechos Reservados 2012 - '.date('Y').' - Xypnos Soluciones Tecnologicas'),0,1,'L');
        }
    }
	
	$pdf = new PDF();
    $pdf->AliasNbPages(); 
    $pdf->setTitle('Reporte de Ventas al Credito');
    $pdf->setAuthor('Miracle v1.5 - Xypnos');
    $pdf->AddPage('L','Letter');
	
	/*Header Tabla*/
	$pdf->Cell(15,8,'Ref',1,0,'C');
	$pdf->Cell(25,8,'Fecha',1,0,'C');
	$pdf->Cell(20,8,'Tipo',1,0,'C');
	$pdf->Cell(30,8,'Documento',1,0,'C');
	$pdf->Cell(45,8,'Cliente',1,0,'C');
	$pdf->Cell(45,8,'Vendedor',1,0,'C');
	$pdf->Cell(45,8,'Cajero',1,0,'C');
	$pdf->Cell(20,8,'Estado',1,0,'C');
	$pdf->Cell(20,8,'Total',1,1,'C');
	$pdf->SetFont('Arial','',9);
	
	  /*Cuerpo del Documento*/
	$total = 0;
	if(isset($transacciones) && count($transacciones) > 0){
		foreach($transacciones as $transaccion):
			$total+=$transaccion->total;
			$pdf->Cell(15,8,"V-".$transaccion->referencia,1,0,'L');
			$pdf->MultiCell(25,4,$transaccion->fecha,1,'C');
			$pdf->SetXY($pdf->GetX()+40,$pdf->GetY()-8);
			$pdf->Cell(20,8,($transaccion->tipo==1)?"Credito":"A Cobro",1,0,'L');
			$doc = $transaccion->documento=$documentos[$transaccion->documento]["shortName"]." No ".$transaccion->numero;
			if($pdf->GetStringWidth($doc) > 30){
				$pdf->MultiCell(30,4,$doc,1,'L');
				$pdf->SetXY($pdf->GetX()+90,$pdf->GetY()-8);				
			}else{
				$pdf->Cell(30,8,$doc,1,0,'L');
			}
			if($pdf->GetStringWidth($transaccion->cliente) > 45){
				$pdf->MultiCell(45,4,$transaccion->cliente,1,'L');
				$pdf->SetXY($pdf->GetX()+135,$pdf->GetY()-8);				
			}else{
				$pdf->Cell(45,8,$transaccion->cliente,1,0,'L');
			}
			if($pdf->GetStringWidth($transaccion->vendedor) > 45){
				$pdf->MultiCell(45,4,$transaccion->vendedor,1,'L');
				$pdf->SetXY($pdf->GetX()+135,$pdf->GetY()-8);				
			}else{
				$pdf->Cell(45,8,$transaccion->vendedor,1,0,'L');
			}
			if($pdf->GetStringWidth($transaccion->cajero) > 45){
				$pdf->MultiCell(45,4,$transaccion->cajero,1,'L');
				$pdf->SetXY($pdf->GetX()+180,$pdf->GetY()-8);				
			}else{
				$pdf->Cell(45,8,$transaccion->cajero,1,0,'L');
			}
			$pdf->Cell(20,8,($transaccion->estado==0)?"Pendiente":"Cancelada",1,0,'L');
			$pdf->Cell(5,8,"$","LTB",0,'L');
			$pdf->Cell(15,8,number_format($transaccion->total,2),"TRB",1,'R');
		endforeach;
		$pdf->SetFont('Arial','B',9);
		$pdf->Cell(225,8,"",0,0,'R');
		$pdf->Cell(20,8,"Total",1,0,'L');
		$pdf->Cell(5,8,"$","LTB",0,'L');
		$pdf->Cell(15,8,number_format($total,2),"TRB",1,'R');
	}
	
	/*Exportamos el PDF*/
    $pdf->Output('Reporte de Ventas al Credito','I');
?>