<div id="grafico-vencimiento-container"></div>
<script>
$(function () {
	<?php
		if(isset($result)):
	?>
    $('#grafico-vencimiento-container').highcharts({
        title: {
            text: 'Grafico de Salida de Productos por Vencimiento Diarias',
            x: -20 //center
        },
        subtitle: {
            text: 'Fuente: Base de Datos Miracle v1.5.0',
            x: -20
        },
        xAxis: {
            categories: [
				<?php
					foreach($result as $res):
						$fecha = explode("-",$res->Fecha);
						echo '"'.$fecha[2].' de '.TraducirMes($fecha[1]).'",';
					endforeach;
				?>
			]
        },
        yAxis: {
            title: {
                text: 'Dolares ($)'
            },
            plotLines: [{
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
		plotOptions: {
            series: {
                dataLabels: {
                    enabled: <?php echo $valores;?>,
					format: '{point.y:.1f} dolares'
                }
            }
        },
        tooltip: {
            valueSuffix: ' dolares'
        },
        legend: {
            layout: 'vertical',
            align: 'right',
            verticalAlign: 'middle',
            borderWidth: 0
        },
        series:[
			{
				name: 'Salidas',
				data: [
					<?php
						foreach($result as $res):
							echo $res->Total.",";
						endforeach;
					?>
				]
			}
		]
    });
	<?php
		else:
	?>
	toastr.options = {
	  "closeButton": true,
	  "progressBar": true,
	  "positionClass": "toast-top-right"
	}
	toastr.error('No hay informacion obtenida para dibujar un grafico');
	<?php
		endif;
	?>
});
</script>
<?php
	function TraducirMes($month){
		switch($month){
			case '01':
					return $mes = 'Enero';
				break;
			case '02':
					return $mes = 'Febrero';
				break;
			case '03':
					return $mes = 'Marzo';
				break;
			case '04':
					return $mes = 'Abril';
				break;
			case '05':
					return $mes = 'Mayo';
				break;
			case '06':
					return $mes = 'Junio';
				break;
			case '07':
					return $mes = 'Julio';
				break;
			case '08':
					return $mes = 'Agosto';
				break;
			case '09':
					return $mes = 'Septiembre';
				break;
			case '10':
					return $mes = 'Octubre';
				break;
			case '11':
					return $mes = 'Noviembre';
				break;
			case '12':
					return $mes = 'Diciembre';
				break;
		}
	}
?>