<div class="wrapper wrapper-content no-padding animated fadeInRight">
	<div class="row">
		<div class="col-sm-7"><!--Tabla productos-->
			<div class="ibox">
				<div class="ibox-content">
					<span class="text-muted small pull-right">
						<?php echo $producto;?> productos encontrados en <?php echo $tiempo;?>
						<i class="fa fa-clock-o"></i>
					</span>
					<h2>Productos</h2>
					<div class="border-bottom row m-b-sm" style="padding:10px;">
						<div class="col-sm-12"><!--Nuevo-->
							<div class="btn-group">
								<button id="i-p-nuevo-producto-btn" class="btn btn btn-info" type="button">
									<i class="fa fa-plus-circle"></i>
									Nuevo producto
								</button>
							</div>
							<div class="btn-group">
								<button class="btn btn-default dropdown-toggle" data-toggle="dropdown">
									<i class="fa fa-file-text-o"></i>
									<span class="caret"></span>
								</button>
								<ul class="dropdown-menu">
									<li>
										<a <?php if($permisos_reporteinventario):?> id="producto-inventario-exportar" href="javascript:void(0)" target="_blank" <?php else:?>onclick="error_noacces()"<?php endif;?>>Reporte de inventario</a>
									</li>
									<li>
										<a <?php if($permisos_reportecatalogo):?>id="producto-inventario-exportar-catalogo" href="javascript:void(0)" <?php else:?>onclick="error_noacces()"<?php endif;?>>Cat&aacute;logo de productos</a>
									</li>
									<li>
										<a <?php if($permisos_reporteinventario):?> id="producto-inventario-exportar-lista-precios"href="javascript:void(0)" target="_blank" <?php else:?>onclick="error_noacces()"<?php endif;?>>Reporte de Lista de Precios</a>
									</li>
								</ul>
							</div>
						</div>
					</div><!--/Productos header-->
					<div >
						<div><!--tabla de productos-->
							<div id="productos-tabla" class="full-height-scroll">
								<div class="table-responsive">
									 <table id="tableInventario" class="table table-striped table-hover">
										<thead>
											<tr>
												<th>SKU</th>
												<th>Producto</th>
												<th>Existencias</th>
												<th>Estado</th>
												<th>Existencias Minimas</th>
												<th>Existencias Max</th>
												<th>ID</th>
											</tr>
										</thead>
										<tbody>
										</tbody>
									 </table>
								</div>
							</div>
						</div><!--/tabla de productos-->
					</div>
				</div>
			</div>
		</div>		
		<div class="col-sm-5"><!--Detalles productos-->
			<div class="ibox">
				<div class="ibox-content">
					<div id="producto-detalles">
						
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<script>
$(document).ready(function(){
	productos.setUrl('<?php echo base_url();?>');
	$('#productos-tabla').slimScroll({height: '500px'});
	$('#producto-detalles').slimScroll({height: '600px'});
		
	$("#tableInventario").dataTable({
		"processing": true,
		"order": [ 0, 'desc' ],
		"serverSide": true,
		"ajax": {
			"url": "<?php echo base_url();?>productos/cargar_inventario",
			"type": "POST"
		},
		/* "columns": [
			{ "data": "id_producto"},
			{ "data": "sku_producto" , "width": "20%"},
			{ "data": "desc_producto" , "width": "45%"},
			{ "data": "exist_act_producto", "width": "15%" },
			{ "data": "exist_min_producto"},
			{ "data": "exist_max_producto"},
			{ "data": "estado", "width": "20%"},
		], */
		"columnDefs": [
			{ "width": "20%", "targets": 0 },
			{ "width": "40%", "targets": 1 },
			{ "width": "20%", "targets": 2 },
			{ "width": "20%", "className" : "myTableActionClass","orderable": false,"searchable": false, "targets": 3},
			{ "targets": 4,"orderable": false,"searchable": false,"visible": false},
			{ "targets": 5,"orderable": false,"searchable": false,"visible": false},
			{ "targets": 6,"className" : "idProductClass"},
		],
		"language": {
			"emptyTable":     "",
			"lengthMenu": "Mostrar _MENU_ registros por pagina",
			"zeroRecords": "",
			"info": "Pagina _PAGE_ de _PAGES_",
			"infoEmpty": "No hay registros",
			"infoFiltered": "(Ningun resultado encontrado de _MAX_ registros)",
			"search":         "Buscar: ",
			"processing":     "<div class='overlay'><i class='fa fa-refresh fa-spin'></i></div>",
			"loadingRecords": "<div class='overlay'><i class='fa fa-refresh fa-spin'></i></div>",
			"paginate": {
				"first":      "Primero",
				"last":       "Ultimo",
				"next":       "Siguiente",
				"previous":   "Anterior"
			}
		},
		"bAutoWidth": false
	});
	
	$("#i-p-nuevo-producto-btn").click(function(e){
		e.preventDefault();
		Custombox.open({
			target:'<?php echo base_url("productos/inventario_nuevo_producto");?>', 
			effect: 'fadein',
			complete:function(){
				$(".modal-body input:text").first().focus();
			}
		});
	});
	
	$("#tableInventario").on("click","td",function(){
		var dataClick = $(this).parent();
		$('#producto-detalles').html("<div class='overlay'><i class='fa fa-refresh fa-spin' style='font-size:50px;margin-top:50px;'></i></div>");
		$('#tableInventario .table-selected-item').removeClass('table-selected-item');
		dataClick.addClass('table-selected-item');
		$.get('<?php echo base_url();?>productos/ver_producto?id='+dataClick.find("td.idProductClass").text())
		.done(function(data){                
			$('#producto-detalles').html(data);
		});
	});
	
	$("#producto-inventario-exportar").click(function(e){
		e.preventDefault();
		Custombox.open({
			target:'<?php echo base_url("reportes/opciones");?>?form=productos', 
			effect: 'fadein',
			complete:function(){
				$(".modal-body input:text").first().focus();
			}
		});
	});
	
	$("#producto-inventario-exportar-catalogo").click(function(e){
		e.preventDefault();
		Custombox.open({
			target:'<?php echo base_url("reportes/opciones");?>?form=catalogoproductos', 
			effect: 'fadein',
			complete:function(){
				$(".modal-body input:text").first().focus();
			}
		});
	});
	
	$("#producto-inventario-exportar-lista-precios").click(function(e){
		e.preventDefault();
		Custombox.open({
			target:'<?php echo base_url("reportes/opciones");?>?form=catalogoprecios', 
			effect: 'fadein',
			complete:function(){
				$(".modal-body input:text").first().focus();
			}
		});
	})
});
</script>